/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.bpmn.backend.converters.tostunner;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.kie.workbench.common.stunner.bpmn.backend.converters.tostunner.BpmnEdge;
import org.kie.workbench.common.stunner.bpmn.backend.converters.tostunner.properties.BasePropertyReader;
import org.kie.workbench.common.stunner.bpmn.definition.BPMNViewDefinition;
import org.kie.workbench.common.stunner.core.graph.Element;
import org.kie.workbench.common.stunner.core.graph.Node;
import org.kie.workbench.common.stunner.core.graph.content.definition.Definition;
import org.kie.workbench.common.stunner.core.graph.content.view.View;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BpmnNode {
    private static final Logger LOG = LoggerFactory.getLogger(BpmnNode.class);
    private final Node<? extends View<? extends BPMNViewDefinition>, ?> value;
    private final List<BpmnNode> children = new ArrayList<BpmnNode>();
    private List<BpmnEdge> edges = new ArrayList<BpmnEdge>();
    private BpmnNode parent;
    private BasePropertyReader propertyReader;

    protected BpmnNode(Node<? extends View<? extends BPMNViewDefinition>, ?> value, BasePropertyReader propertyReader) {
        this.value = value;
        this.propertyReader = propertyReader;
    }

    public abstract boolean isDocked();

    public static BpmnNode of(Node<? extends View<? extends BPMNViewDefinition>, ?> value, BasePropertyReader propertyReader) {
        return new Simple(value, propertyReader);
    }

    public BpmnNode docked() {
        return new Docked(this.value, this.propertyReader);
    }

    public BpmnNode getParent() {
        return this.parent;
    }

    public void setParent(BpmnNode parent) {
        LOG.trace(parent.value().getUUID() + " -> " + this.value.getUUID());
        if (this.parent != null) {
            this.parent.removeChild(this);
        }
        this.parent = parent;
        parent.addChild(this);
    }

    public void addChild(BpmnNode child) {
        this.children.add(child);
    }

    public void removeChild(BpmnNode child) {
        this.children.remove(child);
    }

    public List<BpmnNode> getChildren() {
        return this.children;
    }

    public boolean hasChildren() {
        return !this.children.isEmpty();
    }

    public Node<? extends View<? extends BPMNViewDefinition>, ?> value() {
        return this.value;
    }

    public BasePropertyReader getPropertyReader() {
        return this.propertyReader;
    }

    public void addAllEdges(Collection<BpmnEdge> bpmnEdges) {
        this.edges.addAll(bpmnEdges);
    }

    public List<BpmnEdge> getEdges() {
        return this.edges;
    }

    public boolean addEdge(BpmnEdge bpmnEdge) {
        return this.edges.add(bpmnEdge);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("BpmnNode{");
        sb.append("value=").append(Optional.ofNullable(this.value).map(Element::getContent).filter(Objects::nonNull).map(Definition::getDefinition).filter(Objects::nonNull).map(Object::toString).orElse(""));
        sb.append('}');
        return sb.toString();
    }

    public static class Docked
    extends BpmnNode {
        public Docked(Node<? extends View<? extends BPMNViewDefinition>, ?> value, BasePropertyReader propertyReader) {
            super(value, propertyReader);
        }

        @Override
        public boolean isDocked() {
            return true;
        }
    }

    public static class Simple
    extends BpmnNode {
        public Simple(Node<? extends View<? extends BPMNViewDefinition>, ?> value, BasePropertyReader propertyReader) {
            super(value, propertyReader);
        }

        @Override
        public boolean isDocked() {
            return false;
        }
    }
}

