/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.navigation.service;

import java.util.Arrays;
import java.util.List;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.dashbuilder.navigation.NavGroup;
import org.dashbuilder.navigation.NavItem;
import org.dashbuilder.navigation.NavTree;
import org.dashbuilder.navigation.layout.LayoutNavigationRef;
import org.dashbuilder.navigation.layout.LayoutNavigationRefType;
import org.dashbuilder.navigation.layout.LayoutRecursionIssue;
import org.dashbuilder.navigation.layout.LayoutTemplateContext;
import org.dashbuilder.navigation.layout.NavDragComponentType;
import org.dashbuilder.navigation.service.NavigationServicesImpl;
import org.dashbuilder.navigation.service.PerspectivePluginServicesImpl;
import org.dashbuilder.navigation.workbench.NavWorkbenchCtx;
import org.uberfire.ext.layout.editor.api.editor.LayoutColumn;
import org.uberfire.ext.layout.editor.api.editor.LayoutComponent;
import org.uberfire.ext.layout.editor.api.editor.LayoutRow;
import org.uberfire.ext.layout.editor.api.editor.LayoutTemplate;

@ApplicationScoped
public class LayoutTemplateAnalyzer {
    static final List<NavDragComponentType> ALL_NAV_GROUP_COMPONENTS = Arrays.asList(NavDragComponentType.CAROUSEL, NavDragComponentType.MENUBAR, NavDragComponentType.TABLIST, NavDragComponentType.TREE, NavDragComponentType.TILES);
    static final List<NavDragComponentType> SHOW_ENTIRE_NAV_GROUP_COMPONENTS = Arrays.asList(NavDragComponentType.CAROUSEL);
    static final List<NavDragComponentType> DEFAULT_ITEM_NAV_GROUP_COMPONENTS = Arrays.asList(NavDragComponentType.MENUBAR, NavDragComponentType.TABLIST, NavDragComponentType.TREE);
    private PerspectivePluginServicesImpl pluginServices;
    private NavigationServicesImpl navigationServices;

    public LayoutTemplateAnalyzer() {
    }

    @Inject
    public LayoutTemplateAnalyzer(PerspectivePluginServicesImpl pluginServices, NavigationServicesImpl navigationServices) {
        this.pluginServices = pluginServices;
        this.navigationServices = navigationServices;
    }

    public LayoutRecursionIssue analyzeRecursion(LayoutTemplate layoutTemplate) {
        return this.analyzeRecursion(layoutTemplate, null);
    }

    public LayoutRecursionIssue analyzeRecursion(LayoutTemplate layoutTemplate, LayoutTemplateContext layoutCtx) {
        LayoutRecursionIssue info = new LayoutRecursionIssue();
        info.push(new LayoutNavigationRef(LayoutNavigationRefType.PERSPECTIVE, layoutTemplate.getName()));
        boolean hasIssue = this.analyzeRecursion(layoutTemplate, info, layoutCtx);
        if (!hasIssue) {
            info.pop();
        }
        return info;
    }

    public boolean analyzeRecursion(LayoutTemplate layoutTemplate, LayoutRecursionIssue issue, LayoutTemplateContext layoutCtx) {
        for (LayoutRow row : layoutTemplate.getRows()) {
            boolean hasIssue = this.analyzeRecursion(row, issue, layoutCtx);
            if (!hasIssue) continue;
            return true;
        }
        return false;
    }

    public boolean analyzeRecursion(LayoutRow row, LayoutRecursionIssue issue, LayoutTemplateContext layoutCtx) {
        NavTree navTree = this.navigationServices.loadNavTree();
        for (LayoutColumn column : row.getLayoutColumns()) {
            for (LayoutComponent component : column.getLayoutComponents()) {
                NavGroup navGroup;
                boolean hasIssue;
                issue.push(new LayoutNavigationRef(LayoutNavigationRefType.NAV_COMPONENT, component.getDragTypeName()));
                String perspectiveId = (String)component.getProperties().get("perspectiveId");
                if (perspectiveId != null && (hasIssue = this.analyzeRecursion(perspectiveId, issue))) {
                    return true;
                }
                String navGroupId = (String)component.getProperties().get("navGroupId");
                String navDefaultId = (String)component.getProperties().get("navDefaultId");
                LayoutNavigationRefType navGroupRefType = LayoutNavigationRefType.NAV_GROUP_DEFINED;
                if (layoutCtx != null && layoutCtx.getNavGroupId() != null) {
                    navGroupId = layoutCtx.getNavGroupId();
                    navDefaultId = null;
                    navGroupRefType = LayoutNavigationRefType.NAV_GROUP_CONTEXT;
                } else {
                    NavItem lastDefaultItem;
                    String lastDefaultGroupId;
                    LayoutNavigationRef lastDefaultItemRef = issue.getLastDefaultItemRef();
                    if (lastDefaultItemRef != null && (lastDefaultGroupId = NavWorkbenchCtx.get((NavItem)(lastDefaultItem = navTree.getItemById(lastDefaultItemRef.getName()))).getNavGroupId()) != null) {
                        navGroupId = lastDefaultGroupId;
                        navDefaultId = null;
                        navGroupRefType = LayoutNavigationRefType.NAV_GROUP_CONTEXT;
                    }
                }
                NavGroup navGroup2 = navGroup = navTree != null ? (NavGroup)navTree.getItemById(navGroupId) : null;
                if (navGroup != null) {
                    boolean hasIssue2;
                    NavItem firstItem;
                    if (navDefaultId != null) {
                        issue.push(new LayoutNavigationRef(navGroupRefType, navGroup.getId()));
                        issue.push(new LayoutNavigationRef(LayoutNavigationRefType.DEFAULT_ITEM_DEFINED, navDefaultId));
                        NavItem defaultItem = navTree.getItemById(navDefaultId);
                        NavWorkbenchCtx navCtx = NavWorkbenchCtx.get((NavItem)defaultItem);
                        perspectiveId = navCtx.getResourceId();
                        boolean hasIssue3 = this.analyzeRecursion(perspectiveId, issue);
                        if (hasIssue3) {
                            return true;
                        }
                        issue.pop();
                        issue.pop();
                    } else if (this.hasDefaultItem(component) && (firstItem = this.getFirstRuntimePerspective(navGroup.getChildren())) != null) {
                        issue.push(new LayoutNavigationRef(navGroupRefType, navGroup.getId()));
                        issue.push(new LayoutNavigationRef(LayoutNavigationRefType.DEFAULT_ITEM_FOUND, firstItem.getId()));
                        perspectiveId = NavWorkbenchCtx.get((NavItem)firstItem).getResourceId();
                        boolean hasIssue4 = this.analyzeRecursion(perspectiveId, issue);
                        if (hasIssue4) {
                            return true;
                        }
                        issue.pop();
                        issue.pop();
                    }
                    boolean showAtOnce = this.showEntireNavGroup(component);
                    if (navGroupId != null && showAtOnce && (hasIssue2 = this.analyzeRecursion(navGroup, navGroupRefType, issue))) {
                        return true;
                    }
                }
                issue.pop();
            }
            for (LayoutRow childRow : column.getRows()) {
                boolean hasIssue = this.analyzeRecursion(childRow, issue, layoutCtx);
                if (!hasIssue) continue;
                return true;
            }
        }
        return false;
    }

    public boolean analyzeRecursion(NavGroup navGroup, LayoutNavigationRefType navGroupRefType, LayoutRecursionIssue issue) {
        if (navGroup == null) {
            return false;
        }
        issue.push(new LayoutNavigationRef(navGroupRefType, navGroup.getId()));
        for (NavItem navItem : navGroup.getChildren()) {
            NavWorkbenchCtx navCtx = NavWorkbenchCtx.get((NavItem)navItem);
            String perspectiveId = navCtx.getResourceId();
            boolean hasIssue = this.analyzeRecursion(perspectiveId, issue);
            if (!hasIssue) continue;
            return true;
        }
        issue.pop();
        return false;
    }

    public boolean analyzeRecursion(String perspectiveId, LayoutRecursionIssue issue) {
        LayoutTemplate layoutTemplate = this.pluginServices.getLayoutTemplate(perspectiveId);
        if (layoutTemplate != null) {
            LayoutNavigationRef perspectiveRef = new LayoutNavigationRef(LayoutNavigationRefType.PERSPECTIVE, perspectiveId);
            if (issue.contains(perspectiveRef)) {
                issue.push(new LayoutNavigationRef(LayoutNavigationRefType.PERSPECTIVE, perspectiveId));
                return true;
            }
            issue.push(new LayoutNavigationRef(LayoutNavigationRefType.PERSPECTIVE, perspectiveId));
            boolean hasIssue = this.analyzeRecursion(layoutTemplate, issue, null);
            if (hasIssue) {
                return true;
            }
            issue.pop();
        }
        return false;
    }

    public boolean hasNavigationComponents(LayoutTemplate layoutTemplate) {
        for (LayoutRow row : layoutTemplate.getRows()) {
            boolean hasNavComps = this.hasNavigationComponents(row);
            if (!hasNavComps) continue;
            return true;
        }
        return false;
    }

    public boolean hasNavigationComponents(LayoutRow row) {
        for (LayoutColumn column : row.getLayoutColumns()) {
            for (LayoutComponent component : column.getLayoutComponents()) {
                NavDragComponentType dragType = NavDragComponentType.getByClassName((String)component.getDragTypeName());
                if (dragType == null || !ALL_NAV_GROUP_COMPONENTS.contains(dragType)) continue;
                return true;
            }
            for (LayoutRow childRow : column.getRows()) {
                boolean hasNavComps = this.hasNavigationComponents(childRow);
                if (!hasNavComps) continue;
                return true;
            }
        }
        return false;
    }

    protected boolean showEntireNavGroup(LayoutComponent component) {
        NavDragComponentType dragType = NavDragComponentType.getByClassName((String)component.getDragTypeName());
        return dragType != null && SHOW_ENTIRE_NAV_GROUP_COMPONENTS.contains(dragType);
    }

    protected boolean hasDefaultItem(LayoutComponent component) {
        NavDragComponentType dragType = NavDragComponentType.getByClassName((String)component.getDragTypeName());
        return dragType != null && DEFAULT_ITEM_NAV_GROUP_COMPONENTS.contains(dragType);
    }

    protected boolean isRuntimePerspectiveId(NavItem navItem) {
        NavWorkbenchCtx navCtx = NavWorkbenchCtx.get((NavItem)navItem);
        String perspectiveId = navCtx.getResourceId();
        return this.pluginServices.getLayoutTemplate(perspectiveId) != null;
    }

    protected NavItem getFirstRuntimePerspective(List<NavItem> itemList) {
        if (itemList.isEmpty()) {
            return null;
        }
        for (NavItem navItem : itemList) {
            NavItem result;
            if (this.isRuntimePerspectiveId(navItem)) {
                return navItem;
            }
            if (!(navItem instanceof NavGroup) || (result = this.getFirstRuntimePerspective(((NavGroup)navItem).getChildren())) == null) continue;
            return result;
        }
        return null;
    }
}

