/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.screens.archetype.mgmt.shared.model;

import java.util.Date;
import java.util.Objects;
import org.guvnor.common.services.project.model.GAV;
import org.jboss.errai.common.client.api.annotations.MapsTo;
import org.jboss.errai.common.client.api.annotations.Portable;
import org.kie.soup.commons.validation.PortablePreconditions;
import org.kie.workbench.common.screens.archetype.mgmt.shared.model.ArchetypeStatus;

@Portable
public class Archetype {
    private static final String DEFAULT_MESSAGE = "N/A";
    private final String alias;
    private final GAV gav;
    private final Date createdDate;
    private final ArchetypeStatus status;
    private final String message;
    private final Boolean internal;

    public Archetype(String alias, GAV gav, Date createdDate, ArchetypeStatus status) {
        this(alias, gav, createdDate, status, DEFAULT_MESSAGE);
    }

    public Archetype(String alias, GAV gav, Date createdDate, ArchetypeStatus status, Boolean internal) {
        this(alias, gav, createdDate, status, DEFAULT_MESSAGE, internal);
    }

    public Archetype(String alias, GAV gav, Date createdDate, ArchetypeStatus status, String message) {
        this(alias, gav, createdDate, status, message, false);
    }

    public Archetype(@MapsTo(value="alias") String alias, @MapsTo(value="gav") GAV gav, @MapsTo(value="createdDate") Date createdDate, @MapsTo(value="status") ArchetypeStatus status, @MapsTo(value="message") String message, @MapsTo(value="internal") Boolean internal) {
        this.alias = PortablePreconditions.checkNotEmpty((String)"alias", (String)alias);
        this.gav = (GAV)PortablePreconditions.checkNotNull((String)"gav", (Object)gav);
        this.createdDate = (Date)PortablePreconditions.checkNotNull((String)"createdDate", (Object)createdDate);
        this.status = (ArchetypeStatus)((Object)PortablePreconditions.checkNotNull((String)"status", (Object)((Object)status)));
        this.message = message == null || message.isEmpty() ? DEFAULT_MESSAGE : message;
        this.internal = internal != null && internal != false;
    }

    public String getAlias() {
        return this.alias;
    }

    public GAV getGav() {
        return this.gav;
    }

    public Date getCreatedDate() {
        return this.createdDate;
    }

    public ArchetypeStatus getStatus() {
        return this.status;
    }

    public String getMessage() {
        return this.message;
    }

    public Boolean isInternal() {
        return this.internal;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Archetype archetype = (Archetype)o;
        return this.alias.equals(archetype.alias) && this.gav.equals((Object)archetype.gav) && this.createdDate.equals(archetype.createdDate) && this.status == archetype.status && this.message.equals(archetype.message) && this.internal.equals(archetype.internal);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.alias, this.gav, this.createdDate, this.status, this.message, this.internal});
    }
}

