/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.process.workitem.google.calendar;

import com.google.api.services.calendar.Calendar;
import com.google.api.services.calendar.model.CalendarList;
import com.google.api.services.calendar.model.CalendarListEntry;
import com.google.api.services.calendar.model.Events;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.List;
import org.jbpm.process.workitem.core.AbstractLogOrThrowWorkItemHandler;
import org.jbpm.process.workitem.core.util.RequiredParameterValidator;
import org.jbpm.process.workitem.core.util.Wid;
import org.jbpm.process.workitem.core.util.WidMavenDepends;
import org.jbpm.process.workitem.core.util.WidParameter;
import org.jbpm.process.workitem.core.util.WidResult;
import org.jbpm.process.workitem.core.util.service.WidAction;
import org.jbpm.process.workitem.core.util.service.WidAuth;
import org.jbpm.process.workitem.core.util.service.WidService;
import org.jbpm.process.workitem.google.calendar.GoogleCalendarAuth;
import org.kie.api.runtime.process.WorkItem;
import org.kie.api.runtime.process.WorkItemManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Wid(widfile="GoogleGetEventsDefinitions.wid", name="GoogleGetEvents", displayName="GoogleGetEvents", defaultHandler="mvel: new org.jbpm.process.workitem.google.calendar.GetEventsWorkitemHandler(\"appName\", \"clentSecret\")", documentation="google-calendar-workitem/index.html", category="google-calendar-workitem", icon="GoogleGetEvents.png", parameters={@WidParameter(name="CalendarSummary", required=true)}, results={@WidResult(name="AllEvents", runtimeType="com.google.api.services.calendar.model.Events")}, mavenDepends={@WidMavenDepends(group="org.jbpm.contrib", artifact="google-calendar-workitem", version="7.42.0.Final")}, serviceInfo=@WidService(category="Google Calendar", description="Add and retrieve Calendars and Calendar Events from Google", keywords="google,calendar,events,get,all", action=@WidAction(title="Get all events from an existing Google Calendars"), authinfo=@WidAuth(required=true, params={"appName", "clentSecret"}, paramsdescription={"Google app name", "Google client secret"}, referencesite="https://developers.google.com/calendar/auth")))
public class GetEventsWorkitemHandler
extends AbstractLogOrThrowWorkItemHandler {
    private static final Logger logger = LoggerFactory.getLogger(GetEventsWorkitemHandler.class);
    private static final String RESULTS_ALL_EVENTS = "AllEvents";
    private String appName;
    private String clientSecret;
    private GoogleCalendarAuth auth = new GoogleCalendarAuth();

    public GetEventsWorkitemHandler(String appName, String clentSecret) {
        this.appName = appName;
        this.clientSecret = clentSecret;
    }

    public void executeWorkItem(WorkItem workItem, WorkItemManager workItemManager) {
        String paramCalendarSummary = (String)workItem.getParameter("CalendarSummary");
        HashMap<String, Events> results = new HashMap<String, Events>();
        try {
            RequiredParameterValidator.validate(((Object)((Object)this)).getClass(), (WorkItem)workItem);
            Calendar client = this.auth.getAuthorizedCalendar(this.appName, this.clientSecret);
            results.put(RESULTS_ALL_EVENTS, this.getAllEvents(client, this.getCalendarIdBySummary(client, paramCalendarSummary)));
            workItemManager.completeWorkItem(workItem.getId(), results);
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    public String getCalendarIdBySummary(Calendar client, String summary) {
        String resultId = null;
        try {
            CalendarList calendarList = this.getAllCalendars(client);
            List entryList = calendarList.getItems();
            for (CalendarListEntry entry : entryList) {
                if (!entry.getSummary().equalsIgnoreCase(summary)) continue;
                resultId = entry.getId();
            }
        }
        catch (Exception e) {
            logger.error(MessageFormat.format("Error retrieveing calendars: {0}", e.getMessage()));
        }
        return resultId;
    }

    public CalendarList getAllCalendars(Calendar client) {
        try {
            return (CalendarList)client.calendarList().list().execute();
        }
        catch (Exception e) {
            logger.error(MessageFormat.format("Error trying to get calendars: {0}.", e.getMessage()));
            return null;
        }
    }

    public Events getAllEvents(Calendar client, String calendarId) throws IOException {
        return (Events)client.events().list(calendarId).execute();
    }

    public void abortWorkItem(WorkItem wi, WorkItemManager wim) {
    }

    public void setAuth(GoogleCalendarAuth auth) {
        this.auth = auth;
    }
}

