/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.bpmn.backend.converters.tostunner.processes;

import java.util.Collections;
import org.eclipse.bpmn2.AdHocOrdering;
import org.eclipse.bpmn2.AdHocSubProcess;
import org.eclipse.bpmn2.BaseElement;
import org.eclipse.bpmn2.Definitions;
import org.eclipse.bpmn2.FormalExpression;
import org.eclipse.bpmn2.LoopCharacteristics;
import org.eclipse.bpmn2.SubProcess;
import org.eclipse.bpmn2.di.BPMNDiagram;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.kie.workbench.common.stunner.bpmn.backend.converters.Result;
import org.kie.workbench.common.stunner.bpmn.backend.converters.TypedFactoryManager;
import org.kie.workbench.common.stunner.bpmn.backend.converters.customproperties.CustomElement;
import org.kie.workbench.common.stunner.bpmn.backend.converters.fromstunner.Factories;
import org.kie.workbench.common.stunner.bpmn.backend.converters.tostunner.BpmnNode;
import org.kie.workbench.common.stunner.bpmn.backend.converters.tostunner.ConverterFactory;
import org.kie.workbench.common.stunner.bpmn.backend.converters.tostunner.DefinitionResolver;
import org.kie.workbench.common.stunner.bpmn.backend.converters.tostunner.processes.SubProcessConverter;
import org.kie.workbench.common.stunner.bpmn.backend.converters.tostunner.properties.AdHocSubProcessPropertyReader;
import org.kie.workbench.common.stunner.bpmn.backend.converters.tostunner.properties.PropertyReaderFactory;
import org.kie.workbench.common.stunner.bpmn.definition.AdHocSubprocess;
import org.kie.workbench.common.stunner.bpmn.definition.EmbeddedSubprocess;
import org.kie.workbench.common.stunner.bpmn.definition.EventSubprocess;
import org.kie.workbench.common.stunner.bpmn.definition.MultipleInstanceSubprocess;
import org.kie.workbench.common.stunner.bpmn.definition.property.task.AdHocSubprocessTaskExecutionSet;
import org.kie.workbench.common.stunner.bpmn.definition.property.task.BaseSubprocessTaskExecutionSet;
import org.kie.workbench.common.stunner.bpmn.definition.property.variables.ProcessData;
import org.kie.workbench.common.stunner.core.api.FactoryManager;
import org.kie.workbench.common.stunner.core.definition.adapter.binding.BindableAdapterUtils;
import org.kie.workbench.common.stunner.core.graph.content.Bounds;
import org.kie.workbench.common.stunner.core.graph.content.view.View;
import org.kie.workbench.common.stunner.core.graph.content.view.ViewImpl;
import org.kie.workbench.common.stunner.core.graph.impl.NodeImpl;
import org.mockito.Matchers;
import org.mockito.Mockito;

public class SubProcessConverterTest {
    private final String SLA_DUE_DATE = "12/25/1983";
    private DefinitionResolver definitionResolver;
    private SubProcessConverter tested;

    @Before
    public void setUp() {
        Definitions definitions = Factories.bpmn2.createDefinitions();
        definitions.getRootElements().add(Factories.bpmn2.createProcess());
        BPMNDiagram bpmnDiagram = Factories.di.createBPMNDiagram();
        bpmnDiagram.setPlane(Factories.di.createBPMNPlane());
        definitions.getDiagrams().add(bpmnDiagram);
        this.definitionResolver = new DefinitionResolver(definitions, Collections.emptyList());
        NodeImpl adHocNode = new NodeImpl("");
        ViewImpl adHocContent = new ViewImpl((Object)new AdHocSubprocess(), Bounds.create());
        adHocNode.setContent((Object)adHocContent);
        NodeImpl multipleInstanceNode = new NodeImpl("");
        ViewImpl miContent = new ViewImpl((Object)new MultipleInstanceSubprocess(), Bounds.create());
        multipleInstanceNode.setContent((Object)miContent);
        NodeImpl embeddedNode = new NodeImpl("");
        ViewImpl embeddedContent = new ViewImpl((Object)new EmbeddedSubprocess(), Bounds.create());
        embeddedNode.setContent((Object)embeddedContent);
        NodeImpl eventNode = new NodeImpl("");
        ViewImpl eventSubprocess = new ViewImpl((Object)new EventSubprocess(), Bounds.create());
        eventNode.setContent((Object)eventSubprocess);
        FactoryManager factoryManager = (FactoryManager)Mockito.mock(FactoryManager.class);
        Mockito.when((Object)factoryManager.newElement(Matchers.anyString(), (String)Matchers.eq((Object)BindableAdapterUtils.getDefinitionId(AdHocSubprocess.class)))).thenReturn((Object)adHocNode);
        Mockito.when((Object)factoryManager.newElement(Matchers.anyString(), (String)Matchers.eq((Object)BindableAdapterUtils.getDefinitionId(MultipleInstanceSubprocess.class)))).thenReturn((Object)multipleInstanceNode);
        Mockito.when((Object)factoryManager.newElement(Matchers.anyString(), (String)Matchers.eq((Object)BindableAdapterUtils.getDefinitionId(EmbeddedSubprocess.class)))).thenReturn((Object)embeddedNode);
        Mockito.when((Object)factoryManager.newElement(Matchers.anyString(), (String)Matchers.eq((Object)BindableAdapterUtils.getDefinitionId(EventSubprocess.class)))).thenReturn((Object)eventNode);
        TypedFactoryManager typedFactoryManager = new TypedFactoryManager(factoryManager);
        this.tested = new SubProcessConverter(typedFactoryManager, new PropertyReaderFactory(this.definitionResolver), this.definitionResolver, new ConverterFactory(this.definitionResolver, typedFactoryManager));
    }

    @Test
    public void createNode() {
        Assert.assertTrue((boolean)AdHocSubprocess.class.isInstance(((View)this.tested.createNode("id").getContent()).getDefinition()));
    }

    @Test
    public void createProcessData() {
        Assert.assertTrue((boolean)ProcessData.class.isInstance(this.tested.createProcessData("id")));
    }

    @Test
    public void testCreateAdHocSubprocessTaskExecutionSet() {
        AdHocSubProcess adHocSubProcess = (AdHocSubProcess)Mockito.mock(AdHocSubProcess.class);
        Mockito.when((Object)adHocSubProcess.getCompletionCondition()).thenReturn(Mockito.mock(FormalExpression.class));
        Mockito.when((Object)adHocSubProcess.getOrdering()).thenReturn((Object)AdHocOrdering.SEQUENTIAL);
        Assert.assertTrue((boolean)AdHocSubprocessTaskExecutionSet.class.isInstance(this.tested.createAdHocSubprocessTaskExecutionSet(new AdHocSubProcessPropertyReader(adHocSubProcess, this.definitionResolver.getDiagram(), this.definitionResolver))));
    }

    @Test
    public void testConvertAdHocSubprocessNode() {
        AdHocSubProcess subProcess = Factories.bpmn2.createAdHocSubProcess();
        CustomElement.async.setValue((BaseElement)subProcess, (Object)Boolean.TRUE);
        CustomElement.slaDueDate.setValue((BaseElement)subProcess, (Object)"12/25/1983");
        Result result = this.tested.convertSubProcess((SubProcess)subProcess);
        BpmnNode node = (BpmnNode)result.value();
        AdHocSubprocess adHocSubprocess = (AdHocSubprocess)((View)node.value().getContent()).getDefinition();
        Assert.assertNotNull((Object)adHocSubprocess);
        this.assertBaseSubprocessExecutionSet((BaseSubprocessTaskExecutionSet)adHocSubprocess.getExecutionSet());
    }

    @Test
    public void testConvertMultInstanceSubprocessNode() {
        SubProcess subProcess = Factories.bpmn2.createSubProcess();
        subProcess.setLoopCharacteristics((LoopCharacteristics)Factories.bpmn2.createMultiInstanceLoopCharacteristics());
        CustomElement.async.setValue((BaseElement)subProcess, (Object)Boolean.TRUE);
        CustomElement.slaDueDate.setValue((BaseElement)subProcess, (Object)"12/25/1983");
        Result result = this.tested.convertSubProcess(subProcess);
        BpmnNode node = (BpmnNode)result.value();
        MultipleInstanceSubprocess miSubProcess = (MultipleInstanceSubprocess)((View)node.value().getContent()).getDefinition();
        Assert.assertNotNull((Object)miSubProcess);
        this.assertBaseSubprocessExecutionSet((BaseSubprocessTaskExecutionSet)miSubProcess.getExecutionSet());
    }

    @Test
    public void testConvertEmbeddedSubprocessNode() {
        SubProcess subProcess = Factories.bpmn2.createSubProcess();
        CustomElement.async.setValue((BaseElement)subProcess, (Object)Boolean.TRUE);
        CustomElement.slaDueDate.setValue((BaseElement)subProcess, (Object)"12/25/1983");
        Result result = this.tested.convertSubProcess(subProcess);
        BpmnNode node = (BpmnNode)result.value();
        EmbeddedSubprocess embeddedSubprocess = (EmbeddedSubprocess)((View)node.value().getContent()).getDefinition();
        Assert.assertNotNull((Object)embeddedSubprocess);
        this.assertBaseSubprocessExecutionSet((BaseSubprocessTaskExecutionSet)embeddedSubprocess.getExecutionSet());
    }

    @Test
    public void testConvertEventSubprocessNode() {
        SubProcess subProcess = Factories.bpmn2.createSubProcess();
        subProcess.setTriggeredByEvent(Boolean.TRUE.booleanValue());
        CustomElement.async.setValue((BaseElement)subProcess, (Object)Boolean.TRUE);
        CustomElement.slaDueDate.setValue((BaseElement)subProcess, (Object)"12/25/1983");
        Result result = this.tested.convertSubProcess(subProcess);
        BpmnNode node = (BpmnNode)result.value();
        EventSubprocess eventSubprocess = (EventSubprocess)((View)node.value().getContent()).getDefinition();
        Assert.assertNotNull((Object)eventSubprocess);
        this.assertBaseSubprocessExecutionSet((BaseSubprocessTaskExecutionSet)eventSubprocess.getExecutionSet());
    }

    private void assertBaseSubprocessExecutionSet(BaseSubprocessTaskExecutionSet executionSet) {
        Assert.assertNotNull((Object)executionSet);
        Assert.assertNotNull((Object)executionSet.getIsAsync());
        Assert.assertTrue((boolean)executionSet.getIsAsync().getValue());
        Assert.assertNotNull((Object)executionSet.getSlaDueDate());
        Assert.assertTrue((boolean)executionSet.getSlaDueDate().getValue().contains("12/25/1983"));
    }
}

