/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.bpmn.backend.service.diagram.marshalling.events;

import java.util.List;
import org.assertj.core.api.Assertions;
import org.junit.Assert;
import org.junit.Test;
import org.kie.workbench.common.stunner.bpmn.backend.service.diagram.marshalling.BPMNDiagramMarshallerBaseTest;
import org.kie.workbench.common.stunner.bpmn.definition.BaseStartEvent;
import org.kie.workbench.common.stunner.bpmn.definition.property.dataio.AssignmentsInfo;
import org.kie.workbench.common.stunner.bpmn.definition.property.dataio.DataIOSet;
import org.kie.workbench.common.stunner.bpmn.definition.property.event.BaseStartEventExecutionSet;
import org.kie.workbench.common.stunner.bpmn.definition.property.general.BPMNGeneralSet;
import org.kie.workbench.common.stunner.core.definition.service.DiagramMarshaller;
import org.kie.workbench.common.stunner.core.diagram.Diagram;
import org.kie.workbench.common.stunner.core.diagram.Metadata;
import org.kie.workbench.common.stunner.core.graph.Graph;
import org.kie.workbench.common.stunner.core.graph.Node;
import org.kie.workbench.common.stunner.core.graph.content.definition.Definition;

public abstract class StartEventTest<T extends BaseStartEvent>
extends BPMNDiagramMarshallerBaseTest {
    static final String EMPTY_VALUE = "";
    static final boolean NON_INTERRUPTING = false;
    static final boolean INTERRUPTING = true;
    static final int EMPTY_INCOME_EDGES = 1;
    static final int ONE_OUTCOME_EDGE = 1;
    private Diagram<Graph, Metadata> diagram;
    private Diagram<Graph, Metadata> roundTripDiagram;

    public Diagram<Graph, Metadata> getDiagram() {
        return this.diagram;
    }

    public void setDiagram(Diagram<Graph, Metadata> diagram) {
        this.diagram = diagram;
    }

    public Diagram<Graph, Metadata> getRoundTripDiagram() {
        return this.roundTripDiagram;
    }

    public void setRoundTripDiagram(Diagram<Graph, Metadata> diagram) {
        this.roundTripDiagram = diagram;
    }

    StartEventTest() throws Exception {
        this.marshallDiagramWithNewMarshaller();
    }

    private void marshallDiagramWithNewMarshaller() throws Exception {
        this.setDiagram(this.unmarshall((DiagramMarshaller<Graph, Metadata, Diagram<Graph, Metadata>>)this.marshaller, this.getBpmnStartEventFilePath()));
        this.setRoundTripDiagram(this.unmarshall((DiagramMarshaller<Graph, Metadata, Diagram<Graph, Metadata>>)this.marshaller, this.getStream(this.marshaller.marshall(this.getDiagram()))));
    }

    @Test
    public void testMarshallTopLevelEventFilledProperties() {
        this.checkEventMarshalling(this.getFilledTopLevelEventId());
    }

    @Test
    public void testMarshallTopLevelEmptyEventProperties() {
        this.checkEventMarshalling(this.getEmptyTopLevelEventId());
    }

    @Test
    public void testMarshallSubprocessLevelEventFilledProperties() {
        this.checkEventMarshalling(this.getFilledSubprocessLevelEventId());
    }

    @Test
    public void testMarshallSubprocessLevelEventEmptyProperties() {
        this.checkEventMarshalling(this.getEmptySubprocessLevelEventId());
    }

    public abstract void testUnmarshallTopLevelEventFilledProperties() throws Exception;

    public abstract void testUnmarshallTopLevelEmptyEventProperties() throws Exception;

    public abstract void testUnmarshallSubprocessLevelEventFilledProperties() throws Exception;

    public abstract void testUnmarshallSubprocessLevelEventEmptyProperties() throws Exception;

    abstract Class<T> getStartEventType();

    abstract String getBpmnStartEventFilePath();

    abstract String getFilledTopLevelEventId();

    abstract String getEmptyTopLevelEventId();

    abstract String getFilledSubprocessLevelEventId();

    abstract String getEmptySubprocessLevelEventId();

    T getStartNodeById(Diagram<Graph, Metadata> diagram, String id) {
        return this.getStartNodeById(diagram, id, 1);
    }

    T getStartNodeById(Diagram<Graph, Metadata> diagram, String id, int outcomeEdges) {
        Node<Definition, ?> node = this.getNodeById(diagram, id, outcomeEdges);
        return (T)((BaseStartEvent)this.getStartEventType().cast(((Definition)node.getContent()).getDefinition()));
    }

    void checkEventMarshalling(String nodeID) {
        this.checkEventMarshalling(nodeID, 1);
    }

    void checkEventMarshalling(String nodeID, int outcomeEdges) {
        Diagram<Graph, Metadata> initialDiagram = this.getDiagram();
        int amountOfNodesInDiagram = this.getNodes(initialDiagram).size();
        Diagram<Graph, Metadata> marshalledDiagram = this.getRoundTripDiagram();
        this.assertDiagram(marshalledDiagram, amountOfNodesInDiagram);
        this.assertNodesEqualsAfterMarshalling(initialDiagram, marshalledDiagram, nodeID, outcomeEdges);
    }

    private void assertNodesEqualsAfterMarshalling(Diagram<Graph, Metadata> before, Diagram<Graph, Metadata> after, String nodeId, int outcomeEdges) {
        T nodeBeforeMarshalling = this.getStartNodeById(before, nodeId, outcomeEdges);
        T nodeAfterMarshalling = this.getStartNodeById(after, nodeId, outcomeEdges);
        Assertions.assertThat(nodeAfterMarshalling).isEqualTo(nodeBeforeMarshalling);
    }

    private Node<? extends Definition, ?> getNodeById(Diagram<Graph, Metadata> diagram, String id, int outcomeEdges) {
        Node node = diagram.getGraph().getNode(id);
        Assertions.assertThat((Object)node).isNotNull();
        Assertions.assertThat((List)node.getInEdges()).hasSize(1);
        Assertions.assertThat((List)node.getOutEdges()).hasSize(outcomeEdges);
        return node;
    }

    void assertGeneralSet(BPMNGeneralSet generalSet, String nodeName, String documentation) {
        Assert.assertNotNull((Object)generalSet);
        Assert.assertNotNull((Object)generalSet.getName());
        Assert.assertNotNull((Object)generalSet.getDocumentation());
        Assert.assertEquals((Object)nodeName, (Object)generalSet.getName().getValue());
        Assert.assertEquals((Object)documentation, (Object)generalSet.getDocumentation().getValue());
    }

    void assertDataIOSet(DataIOSet dataIOSet, String value) {
        Assert.assertNotNull((Object)dataIOSet);
        AssignmentsInfo assignmentsInfo = dataIOSet.getAssignmentsinfo();
        Assert.assertNotNull((Object)assignmentsInfo);
        Assert.assertEquals((Object)value, (Object)assignmentsInfo.getValue());
    }

    protected void assertStartEventSlaDueDate(BaseStartEventExecutionSet executionSet, String slaDueDate) {
        Assert.assertNotNull((Object)executionSet.getSlaDueDate());
        Assert.assertEquals((Object)slaDueDate, (Object)executionSet.getSlaDueDate().getValue());
    }

    protected void assertStartEventIsInterrupting(BaseStartEventExecutionSet executionSet, boolean isInterrupting) {
        Assert.assertNotNull((Object)executionSet.getIsInterrupting());
        Assert.assertEquals((Object)isInterrupting, (Object)executionSet.getIsInterrupting().getValue());
    }
}

