/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.bpmn.backend.service.diagram.marshalling.events.intermediate;

import org.assertj.core.api.Assertions;
import org.junit.Test;
import org.kie.workbench.common.stunner.bpmn.backend.service.diagram.marshalling.events.intermediate.CatchingIntermediateEventTest;
import org.kie.workbench.common.stunner.bpmn.definition.IntermediateMessageEventCatching;
import org.kie.workbench.common.stunner.bpmn.definition.property.event.BaseCancellingEventExecutionSet;
import org.kie.workbench.common.stunner.bpmn.definition.property.event.message.CancellingMessageEventExecutionSet;
import org.kie.workbench.common.stunner.core.diagram.Diagram;
import org.kie.workbench.common.stunner.core.diagram.Metadata;
import org.kie.workbench.common.stunner.core.graph.Graph;

public class CatchingIntermediateMessageEventTest
extends CatchingIntermediateEventTest<IntermediateMessageEventCatching> {
    private static final String BPMN_CATCHING_INTERMEDIATE_EVENT_FILE_PATH = "org/kie/workbench/common/stunner/bpmn/backend/service/diagram/catchingIntermediateMessageEvents.bpmn";
    private static final String EMPTY_TOP_LEVEL_EVENT_ID = "D9C771AC-6C9D-459F-960F-B3361B75228D";
    private static final String FILLED_TOP_LEVEL_EVENT_ID = "81518D94-1E20-4448-9F4C-FCFB8E416612";
    private static final String EMPTY_SUBPROCESS_LEVEL_EVENT_ID = "9E62353C-C4B6-4341-9A5A-DA0DBB53F9DC";
    private static final String FILLED_SUBPROCESS_LEVEL_EVENT_ID = "465C4B06-20B3-4D90-B42B-CD6EBDCD9702";
    private static final String EMPTY_WITH_EDGES_SUBPROCESS_LEVEL_EVENT_ID = "4FFBDA99-0EF9-4EDD-997A-68BEDB6A4B72";
    private static final String FILLED_WITH_EDGES_SUBPROCESS_LEVEL_EVENT_ID = "D6C1E0FC-D83E-45A2-A052-354781156E5B";
    private static final String EMPTY_WITH_EDGES_TOP_LEVEL_EVENT_ID = "663A5EEE-9A2F-4E49-8D50-9C4FD5318854";
    private static final String FILLED_WITH_EDGES_TOP_LEVEL_EVENT_ID = "FEDEDC9B-C4EE-47B1-89F2-95F9593E534F";
    private static final String SLA_DUE_DATE = "12/25/1983";
    private static final int AMOUNT_OF_NODES_IN_DIAGRAM = 23;

    @Override
    @Test
    public void testUnmarshallTopLevelEventFilledProperties() throws Exception {
        String EVENT_NAME = "message name ~`!@#$%^&*()_+=-{}|\\][:\";'?><,./";
        String EVENT_DOCUMENTATION = "message documentation\n ~`!@#$%^&*()_+=-{}|\\][:\";'?><,./";
        String EVENT_REF = "message1";
        String EVENT_DATA_OUTPUT = "||message01:String||[dout]message01->processGlobalVar";
        Diagram<Graph, Metadata> diagram = this.getDiagram();
        this.assertDiagram(diagram, 23);
        IntermediateMessageEventCatching filledTopEvent = (IntermediateMessageEventCatching)this.getCatchingIntermediateNodeById(diagram, FILLED_TOP_LEVEL_EVENT_ID, false, 0);
        this.assertGeneralSet(filledTopEvent.getGeneral(), "message name ~`!@#$%^&*()_+=-{}|\\][:\";'?><,./", "message documentation\n ~`!@#$%^&*()_+=-{}|\\][:\";'?><,./");
        this.assertMessageEventExecutionSet(filledTopEvent.getExecutionSet(), "message1", true, SLA_DUE_DATE);
        this.assertDataIOSet(filledTopEvent.getDataIOSet(), "||message01:String||[dout]message01->processGlobalVar");
    }

    @Override
    @Test
    public void testUnmarshallTopLevelEmptyEventProperties() throws Exception {
        Diagram<Graph, Metadata> diagram = this.getDiagram();
        this.assertDiagram(diagram, 23);
        IntermediateMessageEventCatching emptyTopEvent = (IntermediateMessageEventCatching)this.getCatchingIntermediateNodeById(diagram, EMPTY_TOP_LEVEL_EVENT_ID, false, 0);
        this.assertGeneralSet(emptyTopEvent.getGeneral(), "", "");
        this.assertMessageEventExecutionSet(emptyTopEvent.getExecutionSet(), "", true, "");
        this.assertDataIOSet(emptyTopEvent.getDataIOSet(), "");
    }

    @Override
    @Test
    public void testUnmarshallSubprocessLevelEventFilledProperties() throws Exception {
        String EVENT_NAME = "message name ~`!@#$%^&*()_+=-{}|\\][:\";'?><,./";
        String EVENT_DOCUMENTATION = "message documentation\n ~`!@#$%^&*()_+=-{}|\\][:\";'?><,./";
        String EVENT_REF = "message3";
        String EVENT_DATA_OUTPUT = "||message03:String||[dout]message03->processGlobalVar";
        Diagram<Graph, Metadata> diagram = this.getDiagram();
        this.assertDiagram(diagram, 23);
        IntermediateMessageEventCatching filledSubprocessEvent = (IntermediateMessageEventCatching)this.getCatchingIntermediateNodeById(diagram, FILLED_SUBPROCESS_LEVEL_EVENT_ID, false, 0);
        this.assertGeneralSet(filledSubprocessEvent.getGeneral(), "message name ~`!@#$%^&*()_+=-{}|\\][:\";'?><,./", "message documentation\n ~`!@#$%^&*()_+=-{}|\\][:\";'?><,./");
        this.assertMessageEventExecutionSet(filledSubprocessEvent.getExecutionSet(), "message3", true, SLA_DUE_DATE);
        this.assertDataIOSet(filledSubprocessEvent.getDataIOSet(), "||message03:String||[dout]message03->processGlobalVar");
    }

    @Override
    @Test
    public void testUnmarshallSubprocessLevelEventEmptyProperties() throws Exception {
        Diagram<Graph, Metadata> diagram = this.getDiagram();
        this.assertDiagram(diagram, 23);
        IntermediateMessageEventCatching emptySubprocessEvent = (IntermediateMessageEventCatching)this.getCatchingIntermediateNodeById(diagram, EMPTY_SUBPROCESS_LEVEL_EVENT_ID, false, 0);
        this.assertGeneralSet(emptySubprocessEvent.getGeneral(), "", "");
        this.assertMessageEventExecutionSet(emptySubprocessEvent.getExecutionSet(), "", true, "");
        this.assertDataIOSet(emptySubprocessEvent.getDataIOSet(), "");
    }

    @Override
    @Test
    public void testUnmarshallTopLevelEventWithEdgesFilledProperties() {
        String EVENT_NAME = "message name ~`!@#$%^&*()_+=-{}|\\][:\";'?><,./";
        String EVENT_DOCUMENTATION = "message documentation\n ~`!@#$%^&*()_+=-{}|\\][:\";'?><,./";
        String EVENT_REF = "message2";
        String EVENT_DATA_OUTPUT = "||message02:String||[dout]message02->processGlobalVar";
        Diagram<Graph, Metadata> diagram = this.getDiagram();
        this.assertDiagram(diagram, 23);
        IntermediateMessageEventCatching filledSubprocessEvent = (IntermediateMessageEventCatching)this.getCatchingIntermediateNodeById(diagram, FILLED_WITH_EDGES_TOP_LEVEL_EVENT_ID, true, 2);
        this.assertGeneralSet(filledSubprocessEvent.getGeneral(), "message name ~`!@#$%^&*()_+=-{}|\\][:\";'?><,./", "message documentation\n ~`!@#$%^&*()_+=-{}|\\][:\";'?><,./");
        this.assertMessageEventExecutionSet(filledSubprocessEvent.getExecutionSet(), "message2", true, SLA_DUE_DATE);
        this.assertDataIOSet(filledSubprocessEvent.getDataIOSet(), "||message02:String||[dout]message02->processGlobalVar");
    }

    @Override
    @Test
    public void testUnmarshallTopLevelEventWithEdgesEmptyProperties() {
        Diagram<Graph, Metadata> diagram = this.getDiagram();
        this.assertDiagram(diagram, 23);
        IntermediateMessageEventCatching emptyEvent = (IntermediateMessageEventCatching)this.getCatchingIntermediateNodeById(diagram, EMPTY_WITH_EDGES_TOP_LEVEL_EVENT_ID, true, 2);
        this.assertGeneralSet(emptyEvent.getGeneral(), "", "");
        this.assertMessageEventExecutionSet(emptyEvent.getExecutionSet(), "", true, "");
        this.assertDataIOSet(emptyEvent.getDataIOSet(), "");
    }

    @Override
    @Test
    public void testUnmarshallSubprocessLevelEventWithEdgesEmptyProperties() {
        Diagram<Graph, Metadata> diagram = this.getDiagram();
        this.assertDiagram(diagram, 23);
        IntermediateMessageEventCatching emptySubprocessEvent = (IntermediateMessageEventCatching)this.getCatchingIntermediateNodeById(diagram, EMPTY_WITH_EDGES_SUBPROCESS_LEVEL_EVENT_ID, true, 2);
        this.assertGeneralSet(emptySubprocessEvent.getGeneral(), "", "");
        this.assertMessageEventExecutionSet(emptySubprocessEvent.getExecutionSet(), "", true, "");
        this.assertDataIOSet(emptySubprocessEvent.getDataIOSet(), "");
    }

    @Override
    @Test
    public void testUnmarshallSubprocessLevelEventWithEdgesFilledProperties() {
        String EVENT_NAME = "message name ~`!@#$%^&*()_+=-{}|\\][:\";'?><,./";
        String EVENT_DOCUMENTATION = "message documentation\n ~`!@#$%^&*()_+=-{}|\\][:\";'?><,./";
        String EVENT_REF = "message4";
        String EVENT_DATA_OUTPUT = "||message04:String||[dout]message04->processGlobalVar";
        Diagram<Graph, Metadata> diagram = this.getDiagram();
        this.assertDiagram(diagram, 23);
        IntermediateMessageEventCatching filledSubprocessEvent = (IntermediateMessageEventCatching)this.getCatchingIntermediateNodeById(diagram, FILLED_WITH_EDGES_SUBPROCESS_LEVEL_EVENT_ID, true, 2);
        this.assertGeneralSet(filledSubprocessEvent.getGeneral(), "message name ~`!@#$%^&*()_+=-{}|\\][:\";'?><,./", "message documentation\n ~`!@#$%^&*()_+=-{}|\\][:\";'?><,./");
        this.assertMessageEventExecutionSet(filledSubprocessEvent.getExecutionSet(), "message4", true, SLA_DUE_DATE);
        this.assertDataIOSet(filledSubprocessEvent.getDataIOSet(), "||message04:String||[dout]message04->processGlobalVar");
    }

    @Override
    String getBpmnCatchingIntermediateEventFilePath() {
        return BPMN_CATCHING_INTERMEDIATE_EVENT_FILE_PATH;
    }

    @Override
    Class<IntermediateMessageEventCatching> getCatchingIntermediateEventType() {
        return IntermediateMessageEventCatching.class;
    }

    @Override
    String[] getFilledTopLevelEventIds() {
        return new String[]{FILLED_TOP_LEVEL_EVENT_ID};
    }

    @Override
    String getEmptyTopLevelEventId() {
        return EMPTY_TOP_LEVEL_EVENT_ID;
    }

    @Override
    String[] getFilledSubprocessLevelEventIds() {
        return new String[]{FILLED_SUBPROCESS_LEVEL_EVENT_ID};
    }

    @Override
    String getEmptySubprocessLevelEventId() {
        return EMPTY_SUBPROCESS_LEVEL_EVENT_ID;
    }

    @Override
    String[] getFilledTopLevelEventWithEdgesIds() {
        return new String[]{FILLED_WITH_EDGES_TOP_LEVEL_EVENT_ID};
    }

    @Override
    String getEmptyTopLevelEventWithEdgesId() {
        return EMPTY_WITH_EDGES_TOP_LEVEL_EVENT_ID;
    }

    @Override
    String[] getFilledSubprocessLevelEventWithEdgesIds() {
        return new String[]{FILLED_WITH_EDGES_SUBPROCESS_LEVEL_EVENT_ID};
    }

    @Override
    String getEmptySubprocessLevelEventWithEdgesId() {
        return EMPTY_WITH_EDGES_SUBPROCESS_LEVEL_EVENT_ID;
    }

    private void assertMessageEventExecutionSet(CancellingMessageEventExecutionSet executionSet, String eventName, boolean isCancelling, String slaDueDate) {
        Assertions.assertThat((Object)executionSet).isNotNull();
        Assertions.assertThat((Object)executionSet.getMessageRef()).isNotNull();
        Assertions.assertThat((String)executionSet.getMessageRef().getValue()).isEqualTo(eventName);
        this.assertEventCancelActivity((BaseCancellingEventExecutionSet)executionSet, isCancelling);
        this.assertEventSlaDueDate((BaseCancellingEventExecutionSet)executionSet, slaDueDate);
    }
}

