/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.bpmn.backend.converters.customproperties;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.bpmn2.DataObject;
import org.kie.workbench.common.stunner.bpmn.backend.converters.customproperties.AssociationList;
import org.kie.workbench.common.stunner.bpmn.backend.converters.customproperties.DeclarationList;
import org.kie.workbench.common.stunner.bpmn.backend.converters.customproperties.InitializedVariable;
import org.kie.workbench.common.stunner.bpmn.backend.converters.fromstunner.properties.VariableScope;
import org.kie.workbench.common.stunner.bpmn.definition.property.dataio.AssignmentsInfo;

public class ParsedAssignmentsInfo {
    private final DeclarationList inputs;
    private final DeclarationList outputs;
    private final AssociationList associations;
    private final boolean alternativeEncoding;

    public ParsedAssignmentsInfo(DeclarationList inputs, DeclarationList outputs, AssociationList associations, boolean alternativeEncoding) {
        this.inputs = inputs;
        this.outputs = outputs;
        this.associations = associations;
        this.alternativeEncoding = alternativeEncoding;
    }

    public static ParsedAssignmentsInfo of(AssignmentsInfo assignmentsInfo) {
        return ParsedAssignmentsInfo.fromString(assignmentsInfo.getValue());
    }

    public static ParsedAssignmentsInfo fromString(String encoded) {
        DeclarationList inputs = new DeclarationList();
        DeclarationList outputs = new DeclarationList();
        AssociationList associations = new AssociationList();
        if (encoded.isEmpty()) {
            return new ParsedAssignmentsInfo(inputs, outputs, associations, false);
        }
        String[] split = encoded.split("\\|", -1);
        if (split.length == 0) {
            return new ParsedAssignmentsInfo(inputs, outputs, associations, false);
        }
        if (split.length < 5) {
            throw new IllegalArgumentException(encoded);
        }
        boolean alternativeEncoding = false;
        String in = split[0];
        String out = split[2];
        String assoc = split[4];
        if (in.isEmpty() && out.isEmpty() && (!split[1].isEmpty() || !split[3].isEmpty())) {
            alternativeEncoding = true;
            in = split[1];
            out = split[3];
        }
        DeclarationList inputList = DeclarationList.fromString(in);
        DeclarationList outputList = DeclarationList.fromString(out);
        AssociationList associationList = AssociationList.fromString(assoc);
        return new ParsedAssignmentsInfo(inputList, outputList, associationList, alternativeEncoding);
    }

    private static String encodeStringRepresentation(DeclarationList inputs, DeclarationList outputs, AssociationList associations, boolean alternativeEncoding) {
        if (alternativeEncoding) {
            return ParsedAssignmentsInfo.nonCanonicalEncoding(inputs, outputs, associations);
        }
        return ParsedAssignmentsInfo.canonicalEncoding(inputs, outputs, associations);
    }

    private static String canonicalEncoding(DeclarationList inputs, DeclarationList outputs, AssociationList associations) {
        return Stream.of(inputs.toString(), "", outputs.toString(), "", associations.toString()).collect(Collectors.joining("|"));
    }

    private static String nonCanonicalEncoding(DeclarationList inputs, DeclarationList outputs, AssociationList associations) {
        return Stream.of("", inputs.toString(), "", outputs.toString(), associations.toString()).collect(Collectors.joining("|"));
    }

    public DeclarationList getInputs() {
        return this.inputs;
    }

    public DeclarationList getOutputs() {
        return this.outputs;
    }

    public AssociationList getAssociations() {
        return this.associations;
    }

    public List<InitializedVariable.InitializedInputVariable> createInitializedInputVariables(String parentId, VariableScope variableScope, Set<DataObject> dataObjects) {
        return this.getInputs().getDeclarations().stream().map(varDecl -> InitializedVariable.inputOf(parentId, variableScope, varDecl, this.associations.lookupInput(varDecl.getTypedIdentifier().getName()), dataObjects)).collect(Collectors.toList());
    }

    public List<InitializedVariable.InitializedOutputVariable> createInitializedOutputVariables(String parentId, VariableScope variableScope, Set<DataObject> dataObjects) {
        ArrayList<InitializedVariable.InitializedOutputVariable> initializedOutputVariables = new ArrayList<InitializedVariable.InitializedOutputVariable>();
        this.getOutputs().getDeclarations().forEach(varDecl -> {
            if (this.associations.lookupOutputs(varDecl.getTypedIdentifier().getName()).isEmpty()) {
                initializedOutputVariables.add(InitializedVariable.outputOf(parentId, variableScope, varDecl, null, dataObjects));
            } else {
                initializedOutputVariables.addAll(this.associations.lookupOutputs(varDecl.getTypedIdentifier().getName()).stream().map(outputDec -> InitializedVariable.outputOf(parentId, variableScope, this.getOutputs().lookup(outputDec.getSource().replace(" ", "-")), outputDec, dataObjects)).collect(Collectors.toList()));
            }
        });
        return initializedOutputVariables;
    }

    public boolean isEmpty() {
        return this.inputs.getDeclarations().isEmpty() && this.outputs.getDeclarations().isEmpty() && this.associations.getInputs().isEmpty() && this.associations.getOutputs().isEmpty();
    }

    public String toString() {
        if (this.isEmpty()) {
            return "";
        }
        return ParsedAssignmentsInfo.encodeStringRepresentation(this.inputs, this.outputs, this.associations, this.alternativeEncoding);
    }
}

