/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.bpmn.backend.converters.customproperties;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.kie.workbench.common.stunner.bpmn.backend.converters.fromstunner.associations.AssociationType;
import org.kie.workbench.common.stunner.bpmn.definition.property.notification.NotificationTypeListValue;
import org.kie.workbench.common.stunner.bpmn.definition.property.notification.NotificationValue;
import org.kie.workbench.common.stunner.core.util.StringUtils;

public class ParsedNotificationsInfos {
    private ParsedNotificationsInfos() {
    }

    public static NotificationValue of(String type, String body) {
        NotificationValue notification = new NotificationValue();
        notification.setType(type);
        if (StringUtils.nonEmpty((String)body)) {
            String tBody;
            if (body.contains("]@[")) {
                String[] parts = body.split("\\]@\\[");
                notification.setExpiresAt(parts[1].substring(0, parts[1].length() - 1));
                tBody = parts[0].replaceFirst("\\[", "");
            } else {
                tBody = body;
                tBody = ParsedNotificationsInfos.removeBracket(tBody);
            }
            notification.setFrom(ParsedNotificationsInfos.parseElement(tBody, "from"));
            notification.setUsers(ParsedNotificationsInfos.parseGroup(tBody, "tousers"));
            notification.setGroups(ParsedNotificationsInfos.parseGroup(tBody, "togroups"));
            notification.setEmails(String.join((CharSequence)",", ParsedNotificationsInfos.parseGroup(tBody, "toemails")));
            notification.setReplyTo(ParsedNotificationsInfos.parseElement(tBody, "replyTo"));
            notification.setSubject(ParsedNotificationsInfos.replaceVerticalBar(ParsedNotificationsInfos.parseElement(tBody, "subject")));
            notification.setBody(ParsedNotificationsInfos.replaceVerticalBar(ParsedNotificationsInfos.parseElement(tBody, "body")));
        }
        return notification;
    }

    private static String parseElement(String group, String type) {
        return Arrays.stream(group.split("\\|")).filter(x -> x.startsWith(type)).findFirst().orElse("").replace(type + ":", "");
    }

    private static List<String> parseGroup(String group, String type) {
        String result;
        if (group.contains(type) && !(result = Arrays.stream(group.split("\\|")).filter(x -> x.startsWith(type)).findFirst().orElse("").replace(type + ":", "")).isEmpty()) {
            return Arrays.stream(result.split(",")).collect(Collectors.toList());
        }
        return new ArrayList<String>();
    }

    private static String removeBracket(String original) {
        return original.replaceFirst("\\[", "").replaceFirst("\\]([^\\]]*)$", "$1");
    }

    public static String ofCDATA(NotificationTypeListValue values, AssociationType type) {
        return new CDATA(values, type).get();
    }

    private static String replaceVerticalBar(String value) {
        return value != null ? value.replaceAll("&#124;", "|") : null;
    }

    private static class CDATA {
        private final List<NotificationValue> notifications;
        private final AssociationType type;

        CDATA(NotificationTypeListValue value, AssociationType type) {
            this.type = type;
            this.notifications = value.getValues();
        }

        String get() {
            return this.notifications.stream().filter(m -> m.getType().equals(this.type.getName())).map(NotificationValue::toCDATAFormat).collect(Collectors.joining("^"));
        }
    }
}

