/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.bpmn.backend.converters.fromstunner.events;

import java.util.List;
import org.eclipse.bpmn2.CatchEvent;
import org.eclipse.bpmn2.EventDefinition;
import org.eclipse.bpmn2.FlowElement;
import org.eclipse.bpmn2.FlowElementsContainer;
import org.eclipse.bpmn2.LinkEventDefinition;
import org.eclipse.bpmn2.Process;
import org.eclipse.bpmn2.SubProcess;
import org.eclipse.bpmn2.ThrowEvent;
import org.kie.workbench.common.stunner.bpmn.backend.converters.fromstunner.PostConverterProcessor;
import org.kie.workbench.common.stunner.bpmn.backend.converters.fromstunner.properties.BasePropertyWriter;
import org.kie.workbench.common.stunner.bpmn.backend.converters.fromstunner.properties.ProcessPropertyWriter;
import org.kie.workbench.common.stunner.bpmn.definition.BPMNViewDefinition;
import org.kie.workbench.common.stunner.core.graph.Node;
import org.kie.workbench.common.stunner.core.graph.content.view.View;
import org.kie.workbench.common.stunner.core.util.StringUtils;

public class IntermediateLinkEventPostConverter
implements PostConverterProcessor {
    @Override
    public void process(ProcessPropertyWriter processWriter, BasePropertyWriter nodeWriter, Node<View<? extends BPMNViewDefinition>, ?> node) {
        ThrowEvent throwEvent = (ThrowEvent)nodeWriter.getElement();
        List linkEvents = throwEvent.getEventDefinitions();
        if (linkEvents != null && !linkEvents.isEmpty()) {
            this.addTargetRef(processWriter.getProcess(), throwEvent.getId(), (LinkEventDefinition)linkEvents.get(0));
        }
    }

    void addTargetRef(Process process, String nodeId, LinkEventDefinition source) {
        LinkEventDefinition target;
        String linkName = source.getName();
        if (!StringUtils.isEmpty((String)linkName) && (target = this.findTarget((FlowElementsContainer)process, nodeId, linkName)) != null) {
            source.setTarget(target);
        }
    }

    LinkEventDefinition findTarget(FlowElementsContainer container, String nodeId, String linkName) {
        FlowElementsContainer throwEventContainer = this.findContainer(container, nodeId);
        if (throwEventContainer != null) {
            return this.getCatchLinkEventWithSameName(throwEventContainer, linkName);
        }
        return null;
    }

    LinkEventDefinition getCatchLinkEventWithSameName(FlowElementsContainer container, String linkName) {
        for (FlowElement flowElement : container.getFlowElements()) {
            LinkEventDefinition linkDefinition;
            EventDefinition definition;
            CatchEvent event;
            List definitions;
            if (!(flowElement instanceof CatchEvent) || (definitions = (event = (CatchEvent)flowElement).getEventDefinitions()) == null || definitions.isEmpty() || !((definition = (EventDefinition)definitions.get(0)) instanceof LinkEventDefinition) || !linkName.equals((linkDefinition = (LinkEventDefinition)definition).getName())) continue;
            return linkDefinition;
        }
        return null;
    }

    private FlowElementsContainer findContainer(FlowElementsContainer container, String nodeId) {
        for (FlowElement flowElement : container.getFlowElements()) {
            if (flowElement instanceof ThrowEvent) {
                if (!nodeId.equals(flowElement.getId())) continue;
                return container;
            }
            if (!(flowElement instanceof SubProcess) || this.findContainer((FlowElementsContainer)((SubProcess)flowElement), nodeId) == null) continue;
            return (FlowElementsContainer)flowElement;
        }
        return null;
    }
}

