/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.bpmn.backend.converters.tostunner.events;

import java.util.List;
import org.eclipse.bpmn2.CompensateEventDefinition;
import org.eclipse.bpmn2.ConditionalEventDefinition;
import org.eclipse.bpmn2.ErrorEventDefinition;
import org.eclipse.bpmn2.EscalationEventDefinition;
import org.eclipse.bpmn2.EventDefinition;
import org.eclipse.bpmn2.IntermediateThrowEvent;
import org.eclipse.bpmn2.LinkEventDefinition;
import org.eclipse.bpmn2.MessageEventDefinition;
import org.eclipse.bpmn2.SignalEventDefinition;
import org.eclipse.bpmn2.ThrowEvent;
import org.kie.workbench.common.stunner.bpmn.backend.converters.Match;
import org.kie.workbench.common.stunner.bpmn.backend.converters.Result;
import org.kie.workbench.common.stunner.bpmn.backend.converters.TypedFactoryManager;
import org.kie.workbench.common.stunner.bpmn.backend.converters.tostunner.AbstractConverter;
import org.kie.workbench.common.stunner.bpmn.backend.converters.tostunner.BpmnNode;
import org.kie.workbench.common.stunner.bpmn.backend.converters.tostunner.NodeConverter;
import org.kie.workbench.common.stunner.bpmn.backend.converters.tostunner.properties.EventDefinitionReader;
import org.kie.workbench.common.stunner.bpmn.backend.converters.tostunner.properties.EventPropertyReader;
import org.kie.workbench.common.stunner.bpmn.backend.converters.tostunner.properties.PropertyReaderFactory;
import org.kie.workbench.common.stunner.bpmn.backend.converters.tostunner.properties.ThrowEventPropertyReader;
import org.kie.workbench.common.stunner.bpmn.definition.IntermediateCompensationEventThrowing;
import org.kie.workbench.common.stunner.bpmn.definition.IntermediateEscalationEventThrowing;
import org.kie.workbench.common.stunner.bpmn.definition.IntermediateLinkEventThrowing;
import org.kie.workbench.common.stunner.bpmn.definition.IntermediateMessageEventThrowing;
import org.kie.workbench.common.stunner.bpmn.definition.IntermediateSignalEventThrowing;
import org.kie.workbench.common.stunner.bpmn.definition.property.dataio.DataIOSet;
import org.kie.workbench.common.stunner.bpmn.definition.property.event.compensation.ActivityRef;
import org.kie.workbench.common.stunner.bpmn.definition.property.event.compensation.CompensationEventExecutionSet;
import org.kie.workbench.common.stunner.bpmn.definition.property.event.escalation.EscalationEventExecutionSet;
import org.kie.workbench.common.stunner.bpmn.definition.property.event.escalation.EscalationRef;
import org.kie.workbench.common.stunner.bpmn.definition.property.event.link.LinkEventExecutionSet;
import org.kie.workbench.common.stunner.bpmn.definition.property.event.link.LinkRef;
import org.kie.workbench.common.stunner.bpmn.definition.property.event.message.MessageEventExecutionSet;
import org.kie.workbench.common.stunner.bpmn.definition.property.event.message.MessageRef;
import org.kie.workbench.common.stunner.bpmn.definition.property.event.signal.ScopedSignalEventExecutionSet;
import org.kie.workbench.common.stunner.bpmn.definition.property.event.signal.SignalRef;
import org.kie.workbench.common.stunner.bpmn.definition.property.event.signal.SignalScope;
import org.kie.workbench.common.stunner.bpmn.definition.property.general.BPMNGeneralSet;
import org.kie.workbench.common.stunner.bpmn.definition.property.general.Documentation;
import org.kie.workbench.common.stunner.bpmn.definition.property.general.Name;
import org.kie.workbench.common.stunner.core.graph.Node;
import org.kie.workbench.common.stunner.core.graph.content.view.View;
import org.kie.workbench.common.stunner.core.marshaller.MarshallingRequest;

public class IntermediateThrowEventConverter
extends AbstractConverter
implements NodeConverter<IntermediateThrowEvent> {
    private final TypedFactoryManager factoryManager;
    private final PropertyReaderFactory propertyReaderFactory;

    public IntermediateThrowEventConverter(TypedFactoryManager factoryManager, PropertyReaderFactory propertyReaderFactory, MarshallingRequest.Mode mode) {
        super(mode);
        this.factoryManager = factoryManager;
        this.propertyReaderFactory = propertyReaderFactory;
    }

    @Override
    public Result<BpmnNode> convert(IntermediateThrowEvent event) {
        ThrowEventPropertyReader p = this.propertyReaderFactory.of((ThrowEvent)event);
        List<EventDefinition> eventDefinitions = p.getEventDefinitions();
        switch (eventDefinitions.size()) {
            case 0: {
                throw new UnsupportedOperationException("An intermediate throw event should contain exactly one definition");
            }
            case 1: {
                return Match.of(EventDefinition.class, BpmnNode.class).when(SignalEventDefinition.class, e -> this.signalEvent(event, (SignalEventDefinition)e)).when(LinkEventDefinition.class, e -> this.linkEvent(event)).when(MessageEventDefinition.class, e -> this.messageEvent(event, (MessageEventDefinition)e)).when(EscalationEventDefinition.class, e -> this.escalationEvent(event, (EscalationEventDefinition)e)).when(CompensateEventDefinition.class, e -> this.compensationEvent(event, (CompensateEventDefinition)e)).missing(ErrorEventDefinition.class).missing(ConditionalEventDefinition.class).mode(this.getMode()).apply(eventDefinitions.get(0));
            }
        }
        throw new UnsupportedOperationException("Multiple definitions not supported for intermediate throw event");
    }

    private BpmnNode messageEvent(IntermediateThrowEvent event, MessageEventDefinition eventDefinition) {
        Node node = this.factoryManager.newNode(event.getId(), IntermediateMessageEventThrowing.class);
        IntermediateMessageEventThrowing definition = (IntermediateMessageEventThrowing)((View)node.getContent()).getDefinition();
        ThrowEventPropertyReader p = this.propertyReaderFactory.of((ThrowEvent)event);
        definition.setGeneral(new BPMNGeneralSet(new Name(p.getName()), new Documentation(p.getDocumentation())));
        definition.setDataIOSet(new DataIOSet(((EventPropertyReader)p).getAssignmentsInfo()));
        definition.setExecutionSet(new MessageEventExecutionSet(new MessageRef(EventDefinitionReader.messageRefOf(eventDefinition), EventDefinitionReader.messageRefStructureOf(eventDefinition))));
        ((View)node.getContent()).setBounds(p.getBounds());
        definition.setDimensionsSet(p.getCircleDimensionSet());
        definition.setFontSet(p.getFontSet());
        definition.setBackgroundSet(p.getBackgroundSet());
        return BpmnNode.of(node, p);
    }

    private BpmnNode signalEvent(IntermediateThrowEvent event, SignalEventDefinition eventDefinition) {
        Node node = this.factoryManager.newNode(event.getId(), IntermediateSignalEventThrowing.class);
        IntermediateSignalEventThrowing definition = (IntermediateSignalEventThrowing)((View)node.getContent()).getDefinition();
        ThrowEventPropertyReader p = this.propertyReaderFactory.of((ThrowEvent)event);
        definition.setGeneral(new BPMNGeneralSet(new Name(p.getName()), new Documentation(p.getDocumentation())));
        definition.setDataIOSet(new DataIOSet(((EventPropertyReader)p).getAssignmentsInfo()));
        definition.setExecutionSet(new ScopedSignalEventExecutionSet(new SignalRef(p.getSignalRef()), new SignalScope(p.getSignalScope())));
        ((View)node.getContent()).setBounds(p.getBounds());
        definition.setDimensionsSet(p.getCircleDimensionSet());
        definition.setFontSet(p.getFontSet());
        definition.setBackgroundSet(p.getBackgroundSet());
        return BpmnNode.of(node, p);
    }

    private BpmnNode linkEvent(IntermediateThrowEvent event) {
        Node node = this.factoryManager.newNode(event.getId(), IntermediateLinkEventThrowing.class);
        IntermediateLinkEventThrowing definition = (IntermediateLinkEventThrowing)((View)node.getContent()).getDefinition();
        ThrowEventPropertyReader p = this.propertyReaderFactory.of((ThrowEvent)event);
        definition.setGeneral(new BPMNGeneralSet(new Name(p.getName()), new Documentation(p.getDocumentation())));
        definition.setExecutionSet(new LinkEventExecutionSet(new LinkRef(p.getLinkRef())));
        ((View)node.getContent()).setBounds(p.getBounds());
        definition.setDimensionsSet(p.getCircleDimensionSet());
        definition.setFontSet(p.getFontSet());
        definition.setBackgroundSet(p.getBackgroundSet());
        return BpmnNode.of(node, p);
    }

    private BpmnNode escalationEvent(IntermediateThrowEvent event, EscalationEventDefinition eventDefinition) {
        Node node = this.factoryManager.newNode(event.getId(), IntermediateEscalationEventThrowing.class);
        IntermediateEscalationEventThrowing definition = (IntermediateEscalationEventThrowing)((View)node.getContent()).getDefinition();
        ThrowEventPropertyReader p = this.propertyReaderFactory.of((ThrowEvent)event);
        definition.setGeneral(new BPMNGeneralSet(new Name(p.getName()), new Documentation(p.getDocumentation())));
        definition.setDataIOSet(new DataIOSet(((EventPropertyReader)p).getAssignmentsInfo()));
        definition.setExecutionSet(new EscalationEventExecutionSet(new EscalationRef(EventDefinitionReader.escalationRefOf(eventDefinition))));
        ((View)node.getContent()).setBounds(p.getBounds());
        definition.setDimensionsSet(p.getCircleDimensionSet());
        definition.setFontSet(p.getFontSet());
        definition.setBackgroundSet(p.getBackgroundSet());
        return BpmnNode.of(node, p);
    }

    private BpmnNode compensationEvent(IntermediateThrowEvent event, CompensateEventDefinition eventDefinition) {
        Node node = this.factoryManager.newNode(event.getId(), IntermediateCompensationEventThrowing.class);
        IntermediateCompensationEventThrowing definition = (IntermediateCompensationEventThrowing)((View)node.getContent()).getDefinition();
        ThrowEventPropertyReader p = this.propertyReaderFactory.of((ThrowEvent)event);
        definition.setGeneral(new BPMNGeneralSet(new Name(p.getName()), new Documentation(p.getDocumentation())));
        definition.setExecutionSet(new CompensationEventExecutionSet(new ActivityRef(EventDefinitionReader.activityRefOf(eventDefinition))));
        ((View)node.getContent()).setBounds(p.getBounds());
        definition.setDimensionsSet(p.getCircleDimensionSet());
        definition.setFontSet(p.getFontSet());
        definition.setBackgroundSet(p.getBackgroundSet());
        return BpmnNode.of(node, p);
    }
}

