/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.bpmn.backend.converters.tostunner.properties;

import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.eclipse.bpmn2.BaseElement;
import org.eclipse.bpmn2.FlowElement;
import org.eclipse.bpmn2.Process;
import org.eclipse.bpmn2.di.BPMNDiagram;
import org.eclipse.bpmn2.di.BPMNShape;
import org.kie.workbench.common.stunner.bpmn.backend.converters.customproperties.CustomAttribute;
import org.kie.workbench.common.stunner.bpmn.backend.converters.customproperties.CustomElement;
import org.kie.workbench.common.stunner.bpmn.backend.converters.tostunner.properties.BasePropertyReader;
import org.kie.workbench.common.stunner.bpmn.backend.converters.tostunner.properties.CaseFileVariableReader;
import org.kie.workbench.common.stunner.bpmn.backend.converters.tostunner.properties.ProcessVariableReader;
import org.kie.workbench.common.stunner.bpmn.definition.property.diagram.imports.DefaultImport;
import org.kie.workbench.common.stunner.core.graph.content.Bounds;

public class ProcessPropertyReader
extends BasePropertyReader {
    private final Process process;
    private final Map<String, FlowElement> flowElements;

    public ProcessPropertyReader(Process element, BPMNDiagram diagram, BPMNShape shape, double resolutionFactor) {
        super((BaseElement)element, diagram, shape, resolutionFactor);
        this.process = element;
        this.flowElements = this.process.getFlowElements().stream().collect(Collectors.toMap(BaseElement::getId, Function.identity()));
    }

    public String getPackage() {
        return CustomAttribute.packageName.of(this.element).get();
    }

    public String getProcessType() {
        return this.process.getProcessType().getName();
    }

    public String getVersion() {
        return CustomAttribute.version.of(this.element).get();
    }

    public boolean isAdHoc() {
        return CustomAttribute.adHoc.of(this.element).get();
    }

    @Override
    public Bounds getBounds() {
        return Bounds.create((double)0.0, (double)0.0, (double)950.0, (double)950.0);
    }

    public String getProcessVariables() {
        return ProcessVariableReader.getProcessVariables(this.process.getProperties());
    }

    public String getCaseIdPrefix() {
        return (String)CustomElement.caseIdPrefix.of((BaseElement)this.process).get();
    }

    public String getCaseFileVariables() {
        return CaseFileVariableReader.getCaseFileVariables(this.process.getProperties());
    }

    public String getCaseRoles() {
        return (String)CustomElement.caseRole.of((BaseElement)this.process).get();
    }

    public FlowElement getFlowElement(String id) {
        return this.flowElements.get(id);
    }

    public String getGlobalVariables() {
        return (String)CustomElement.globalVariables.of((BaseElement)this.process).get();
    }

    public String getMetaDataAttributes() {
        return (String)CustomElement.metaDataAttributes.of((BaseElement)this.process).get();
    }

    public List<DefaultImport> getDefaultImports() {
        return (List)CustomElement.defaultImports.of((BaseElement)this.process).get();
    }

    public String getSlaDueDate() {
        return (String)CustomElement.slaDueDate.of((BaseElement)this.process).get();
    }
}

