/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.core.command.impl;

import java.util.LinkedList;
import java.util.List;
import java.util.function.Supplier;
import org.jboss.errai.common.client.api.annotations.MapsTo;
import org.jboss.errai.common.client.api.annotations.NonPortable;
import org.jboss.errai.common.client.api.annotations.Portable;
import org.kie.workbench.common.stunner.core.command.Command;
import org.kie.workbench.common.stunner.core.command.CommandResult;
import org.kie.workbench.common.stunner.core.command.impl.AbstractCompositeCommand;
import org.kie.workbench.common.stunner.core.command.impl.DeferredCommand;
import org.kie.workbench.common.stunner.core.command.util.CommandUtils;

@Portable
public class DeferredCompositeCommand<T, V>
extends AbstractCompositeCommand<T, V> {
    static final String ILLEGAL_ALLOW_MESSAGE = "Deferred commands cannot be evaluated previous to the execution";
    private final boolean reverse;

    public DeferredCompositeCommand(@MapsTo(value="reverse") boolean reverse) {
        this.reverse = reverse;
    }

    @Override
    public CommandResult<V> allow(T context) {
        throw new IllegalStateException(ILLEGAL_ALLOW_MESSAGE);
    }

    @Override
    public CommandResult<V> execute(T context) {
        return this.executeCommands(context);
    }

    @Override
    protected CommandResult<V> doExecute(T context, Command<T, V> command) {
        CommandResult violations = this.doAllow(context, command);
        if (!CommandUtils.isError(violations)) {
            violations = command.execute(context);
        }
        return violations;
    }

    @Override
    protected CommandResult<V> doUndo(T context, Command<T, V> command) {
        return command.undo(context);
    }

    @Override
    public boolean isUndoReverse() {
        return this.reverse;
    }

    @NonPortable
    public static class Builder<T, V> {
        private final List<Command<T, V>> commands = new LinkedList<Command<T, V>>();
        private boolean reverse = true;

        public Builder<T, V> reverse() {
            this.reverse = true;
            return this;
        }

        public Builder<T, V> forward() {
            this.reverse = false;
            return this;
        }

        public Builder<T, V> deferCommand(Supplier<Command<T, V>> commandSupplier) {
            this.commands.add(new DeferredCommand<T, V>(commandSupplier));
            return this;
        }

        public int size() {
            return this.commands.size();
        }

        public DeferredCompositeCommand<T, V> build() {
            DeferredCompositeCommand compositeCommand = new DeferredCompositeCommand(this.reverse);
            this.commands.forEach(compositeCommand::addCommand);
            return compositeCommand;
        }
    }
}

