/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.core.definition.clone;

import java.util.AbstractMap;
import java.util.Objects;
import java.util.Optional;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.jboss.errai.databinding.client.BindableProxy;
import org.jboss.errai.databinding.client.BindableProxyFactory;
import org.kie.workbench.common.stunner.core.api.FactoryManager;
import org.kie.workbench.common.stunner.core.definition.adapter.AdapterManager;
import org.kie.workbench.common.stunner.core.definition.clone.AbstractCloneProcess;
import org.kie.workbench.common.stunner.core.definition.clone.IDeepCloneProcess;
import org.kie.workbench.common.stunner.core.util.ClassUtils;

@ApplicationScoped
public class DeepCloneProcess
extends AbstractCloneProcess
implements IDeepCloneProcess {
    private final ClassUtils classUtils;

    protected DeepCloneProcess() {
        this(null, null, null);
    }

    @Inject
    public DeepCloneProcess(FactoryManager factoryManager, AdapterManager adapterManager, ClassUtils classUtils) {
        super(factoryManager, adapterManager);
        this.classUtils = classUtils;
    }

    @Override
    public <S, T> T clone(S source, T target) {
        this.adapterManager.forDefinition().getProperties(source).stream().filter(p -> !this.adapterManager.forProperty().isReadOnly(p)).map(p -> {
            String id = this.adapterManager.forProperty().getId(p);
            Optional<Object> propertyTarget = this.adapterManager.forDefinition().getProperties(target).stream().filter(prop -> Objects.equals(this.adapterManager.forProperty().getId(prop), id)).findFirst();
            return propertyTarget.isPresent() ? new AbstractMap.SimpleEntry<Object, Object>(p, propertyTarget.get()) : null;
        }).filter(Objects::nonNull).filter(entry -> this.isAllowedToClone(this.adapterManager.forProperty().getValue(entry.getKey()))).forEach(entry -> {
            Object value = this.adapterManager.forProperty().getValue(entry.getKey());
            this.adapterManager.forProperty().setValue(entry.getValue(), this.cloneValue(value));
        });
        return target;
    }

    private boolean isAllowedToClone(Object value) {
        return Objects.nonNull(value) && (this.isSimpleValue(value) || BindableProxyFactory.isBindableType((Object)value));
    }

    private boolean isSimpleValue(Object value) {
        return value instanceof String || this.classUtils.isPrimitiveClass(value.getClass());
    }

    private Object cloneValue(Object value) {
        if (value == null || this.isSimpleValue(value)) {
            return value;
        }
        BindableProxy bindableProxy = (BindableProxy)BindableProxyFactory.getBindableProxy((Object)value);
        return bindableProxy.deepUnwrap();
    }
}

