/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.core.graph.command.impl;

import org.jboss.errai.common.client.api.annotations.MapsTo;
import org.jboss.errai.common.client.api.annotations.Portable;
import org.kie.soup.commons.validation.PortablePreconditions;
import org.kie.workbench.common.stunner.core.api.DefinitionManager;
import org.kie.workbench.common.stunner.core.command.CommandResult;
import org.kie.workbench.common.stunner.core.definition.adapter.DefinitionAdapter;
import org.kie.workbench.common.stunner.core.definition.adapter.MorphAdapter;
import org.kie.workbench.common.stunner.core.definition.morph.MorphDefinition;
import org.kie.workbench.common.stunner.core.factory.impl.AbstractElementFactory;
import org.kie.workbench.common.stunner.core.graph.Edge;
import org.kie.workbench.common.stunner.core.graph.Node;
import org.kie.workbench.common.stunner.core.graph.command.GraphCommandExecutionContext;
import org.kie.workbench.common.stunner.core.graph.command.GraphCommandResultBuilder;
import org.kie.workbench.common.stunner.core.graph.command.impl.AbstractGraphCommand;
import org.kie.workbench.common.stunner.core.graph.content.definition.Definition;
import org.kie.workbench.common.stunner.core.rule.RuleViolation;

@Portable
public final class MorphNodeCommand
extends AbstractGraphCommand {
    private final String uuid;
    private final MorphDefinition morphDefinition;
    private final String morphTarget;
    private transient String oldMorphTarget;
    private transient Node<Definition, Edge> candidate;

    public MorphNodeCommand(@MapsTo(value="uuid") String uuid, @MapsTo(value="morphDefinition") MorphDefinition morphDefinition, @MapsTo(value="morphTarget") String morphTarget) {
        this.uuid = (String)PortablePreconditions.checkNotNull((String)"uuid", (Object)uuid);
        this.morphDefinition = (MorphDefinition)PortablePreconditions.checkNotNull((String)"morphDefinition", (Object)morphDefinition);
        this.morphTarget = (String)PortablePreconditions.checkNotNull((String)"morphTarget", (Object)morphTarget);
        this.oldMorphTarget = null;
        this.candidate = null;
    }

    public MorphNodeCommand(Node<Definition, Edge> candidate, MorphDefinition morphDefinition, String morphTarget) {
        this(candidate.getUUID(), morphDefinition, morphTarget);
        this.candidate = (Node)PortablePreconditions.checkNotNull((String)"candidate", candidate);
    }

    public CommandResult<RuleViolation> execute(GraphCommandExecutionContext context) {
        String currentDefId;
        this.checkSafeCandidate(context);
        CommandResult<RuleViolation> results = this.check(context);
        DefinitionManager definitionManager = context.getDefinitionManager();
        Object currentDef = ((Definition)this.candidate.getContent()).getDefinition();
        this.oldMorphTarget = currentDefId = definitionManager.adapters().forDefinition().getId(currentDef).value();
        MorphAdapter morphAdapter = context.getDefinitionManager().adapters().registry().getMorphAdapter(currentDef.getClass());
        if (null == morphAdapter) {
            throw new RuntimeException("No morph adapter found for definition [" + currentDef.toString() + "] and target morph [" + this.morphTarget + "]");
        }
        Object targetDef = morphAdapter.morph(currentDef, this.morphDefinition, this.morphTarget);
        if (null == targetDef) {
            throw new RuntimeException("No morph resulting Definition. [ morphSource=" + currentDefId + ", morphTarget=" + this.morphTarget + "]");
        }
        ((Definition)this.candidate.getContent()).setDefinition(targetDef);
        DefinitionAdapter adapter = definitionManager.adapters().registry().getDefinitionAdapter(targetDef.getClass());
        this.candidate.getLabels().clear();
        this.candidate.getLabels().addAll(AbstractElementFactory.computeLabels(adapter, targetDef));
        return results;
    }

    @Override
    protected CommandResult<RuleViolation> check(GraphCommandExecutionContext context) {
        return GraphCommandResultBuilder.SUCCESS;
    }

    public CommandResult<RuleViolation> undo(GraphCommandExecutionContext context) {
        MorphNodeCommand undoCommand = new MorphNodeCommand(this.uuid, this.morphDefinition, this.oldMorphTarget);
        return undoCommand.execute(context);
    }

    private void checkSafeCandidate(GraphCommandExecutionContext context) {
        if (null == this.candidate) {
            this.candidate = super.getNodeNotNull(context, this.uuid);
        }
    }

    public String toString() {
        return "MorphNodeCommand [candidate=" + this.uuid + ", morphTarget=" + this.morphTarget + "]";
    }
}

