/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.core.graph.processing.layout.sugiyama.step04;

import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.enterprise.inject.Default;
import org.kie.workbench.common.stunner.core.graph.processing.layout.OrientedEdgeImpl;
import org.kie.workbench.common.stunner.core.graph.processing.layout.ReorderedGraph;
import org.kie.workbench.common.stunner.core.graph.processing.layout.Vertex;
import org.kie.workbench.common.stunner.core.graph.processing.layout.sugiyama.GraphLayer;
import org.kie.workbench.common.stunner.core.graph.processing.layout.sugiyama.LayeredGraph;
import org.kie.workbench.common.stunner.core.graph.processing.layout.sugiyama.OrientedEdge;
import org.kie.workbench.common.stunner.core.graph.processing.layout.sugiyama.step04.LayerArrangement;
import org.kie.workbench.common.stunner.core.graph.processing.layout.sugiyama.step04.VertexPositioning;

@Default
public class DefaultVertexPositioning
implements VertexPositioning {
    static final int DEFAULT_VERTEX_SPACE = 75;
    private static final int DEFAULT_LAYER_SPACE = 125;
    static final int DEFAULT_LAYER_HORIZONTAL_PADDING = 50;
    static final int DEFAULT_LAYER_VERTICAL_PADDING = 50;

    public void calculateVerticesPositions(ReorderedGraph graph, LayerArrangement arrangement) {
        LayeredGraph layered = (LayeredGraph)graph;
        this.deReverseEdges(graph);
        Set<Vertex> vertices = this.getVertices(layered);
        this.removeVirtualVertices(graph.getEdges(), vertices);
        this.removeVirtualVerticesFromLayers(layered.getLayers(), vertices);
        this.arrangeVertices(layered.getLayers(), arrangement, graph);
    }

    Set<Vertex> getVertices(LayeredGraph layered) {
        return layered.getLayers().stream().flatMap(l -> l.getVertices().stream()).collect(Collectors.toSet());
    }

    void deReverseEdges(ReorderedGraph graph) {
        for (OrientedEdge edge : graph.getEdges()) {
            if (!edge.isReversed()) continue;
            edge.reverse();
        }
    }

    void arrangeVertices(List<GraphLayer> layers, LayerArrangement arrangement, ReorderedGraph graph) {
        HashMap<Integer, Integer> layersWidth = this.createHashForLayersWidth();
        int largestWidth = this.calculateLayersWidth(layers, layersWidth);
        HashMap<Integer, Integer> layersStartX = this.getLayersStartX(layers.size(), layersWidth, largestWidth);
        int y = 50;
        switch (arrangement) {
            case TopDown: {
                for (int i = 0; i < layers.size(); ++i) {
                    y = this.distributeVertices(layers, layersStartX, y, i, graph);
                }
                break;
            }
            case BottomUp: {
                for (int i = layers.size() - 1; i >= 0; --i) {
                    y = this.distributeVertices(layers, layersStartX, y, i, graph);
                }
                break;
            }
        }
    }

    HashMap<Integer, Integer> createHashForLayersWidth() {
        return new HashMap<Integer, Integer>();
    }

    HashMap<Integer, Integer> getLayersStartX(int layersCount, HashMap<Integer, Integer> layersWidth, int largestWidth) {
        HashMap<Integer, Integer> layersStartX = new HashMap<Integer, Integer>();
        for (int i = 0; i < layersCount; ++i) {
            int middle = largestWidth / 2;
            int layerWidth = layersWidth.get(i);
            int firstHalf = layerWidth / 2;
            int startPoint = middle - firstHalf;
            layersStartX.put(i, startPoint += 50);
        }
        return layersStartX;
    }

    int calculateLayersWidth(List<GraphLayer> layers, HashMap<Integer, Integer> layersWidth) {
        int largestWidth = 0;
        for (int i = 0; i < layers.size(); ++i) {
            GraphLayer layer = layers.get(i);
            int currentWidth = layer.getVertices().size() * 100;
            layersWidth.put(i, currentWidth += (layer.getVertices().size() - 1) * 75);
            largestWidth = Math.max(largestWidth, currentWidth);
        }
        return largestWidth;
    }

    int distributeVertices(List<GraphLayer> layers, HashMap<Integer, Integer> layersStartX, int y, int i, ReorderedGraph graph) {
        GraphLayer layer = layers.get(i);
        int x = layersStartX.get(i);
        int highestY = 0;
        for (Vertex v : layer.getVertices()) {
            v.setX(x);
            v.setY(y);
            x += 75;
            x += graph.getVertexWidth(v.getId());
            highestY = Math.max(highestY, graph.getVertexHeight(v.getId()));
        }
        return y + highestY + 125;
    }

    void removeVirtualVerticesFromLayers(List<GraphLayer> layers, Set<Vertex> vertices) {
        Set ids = vertices.stream().map(Vertex::getId).collect(Collectors.toSet());
        for (GraphLayer layer : layers) {
            for (int i = 0; i < layer.getVertices().size(); ++i) {
                Vertex existingVertex = (Vertex)layer.getVertices().get(i);
                if (ids.contains(existingVertex.getId())) continue;
                layer.getVertices().remove(existingVertex);
                --i;
            }
        }
    }

    public boolean removeVirtualVertex(OrientedEdge edge, List<OrientedEdge> edges, Set<Vertex> vertices) {
        Optional<Vertex> fromVirtual;
        Optional<Vertex> toVirtual = vertices.stream().filter(v -> v.isVirtual() && Objects.equals(edge.getToVertexId(), v.getId())).findFirst();
        OrientedEdgeImpl newEdge = null;
        if (toVirtual.isPresent()) {
            String virtualVertex = edge.getToVertexId();
            Optional<OrientedEdge> otherSide = edges.stream().filter(e -> Objects.equals(e.getFromVertexId(), virtualVertex)).findFirst();
            if (otherSide.isPresent()) {
                String realToVertex = otherSide.get().getToVertexId();
                newEdge = new OrientedEdgeImpl(edge.getFromVertexId(), realToVertex);
                edges.remove(edge);
                vertices.remove(toVirtual.get());
                Optional<OrientedEdge> oldEdge = edges.stream().filter(e -> Objects.equals(e.getFromVertexId(), ((Vertex)toVirtual.get()).getId()) && Objects.equals(e.getToVertexId(), realToVertex)).findFirst();
                oldEdge.ifPresent(edges::remove);
            }
        }
        if ((fromVirtual = vertices.stream().filter(v -> v.isVirtual() && Objects.equals(edge.getFromVertexId(), v.getId())).findFirst()).isPresent()) {
            String virtualVertex = edge.getFromVertexId();
            Optional<OrientedEdge> otherSide = edges.stream().filter(e -> Objects.equals(e.getToVertexId(), virtualVertex)).findFirst();
            if (otherSide.isPresent()) {
                String realFromVertex = otherSide.get().getFromVertexId();
                newEdge = newEdge == null ? new OrientedEdgeImpl(realFromVertex, edge.getToVertexId()) : new OrientedEdgeImpl(realFromVertex, newEdge.getToVertexId());
                edges.remove(edge);
                vertices.remove(fromVirtual.get());
                Optional<OrientedEdge> oldEdge = edges.stream().filter(e -> Objects.equals(e.getToVertexId(), ((Vertex)fromVirtual.get()).getId())).findFirst();
                oldEdge.ifPresent(edges::remove);
            }
        }
        if (newEdge != null) {
            edges.add(newEdge);
            return true;
        }
        return false;
    }

    public void removeVirtualVertices(List<OrientedEdge> edges, Set<Vertex> vertices) {
        while (vertices.stream().anyMatch(Vertex::isVirtual)) {
            for (int i = 0; i < edges.size(); ++i) {
                if (!this.removeVirtualVertex(edges.get(i), edges, vertices)) continue;
                --i;
            }
        }
    }
}

