/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.core.i18n;

import java.util.Optional;
import org.kie.soup.commons.validation.PortablePreconditions;
import org.kie.workbench.common.stunner.core.i18n.StunnerTranslationService;
import org.kie.workbench.common.stunner.core.rule.RuleViolation;

public abstract class AbstractTranslationService
implements StunnerTranslationService {
    public static final String I18N_SEPARATOR = ".";
    public static final String TITLE_SUFFIX = "title";
    public static final String DESCRIPTION_SUFFIX = "description";
    public static final String SVG_NODE_ID_SUFFIX = "svgNodeId";
    public static final String CAPTION_SUFFIX = "caption";
    public static final String LABEL_SUFFIX = "label";

    public String getDefinitionSetDescription(String defSetId) {
        PortablePreconditions.checkNotNull((String)"defSetId", (Object)defSetId);
        return this.getValue(defSetId + I18N_SEPARATOR + DESCRIPTION_SUFFIX);
    }

    public String getPropertySetName(String propSetId) {
        return this.getValue(propSetId + I18N_SEPARATOR + CAPTION_SUFFIX);
    }

    public String getDefinitionTitle(String defId) {
        PortablePreconditions.checkNotNull((String)"defId", (Object)defId);
        return this.getValue(defId + I18N_SEPARATOR + TITLE_SUFFIX);
    }

    public String getDefinitionDescription(String defId) {
        PortablePreconditions.checkNotNull((String)"defId", (Object)defId);
        return this.getValue(defId + I18N_SEPARATOR + DESCRIPTION_SUFFIX);
    }

    public Optional<String> getDefinitionSetSvgNodeId(String defId) {
        return Optional.ofNullable(this.getValue(defId + I18N_SEPARATOR + SVG_NODE_ID_SUFFIX));
    }

    public String getPropertyCaption(String propId) {
        PortablePreconditions.checkNotNull((String)"propId", (Object)propId);
        return Optional.ofNullable(this.getValue(propId + I18N_SEPARATOR + CAPTION_SUFFIX)).orElseGet(() -> Optional.ofNullable(this.getValue(propId + I18N_SEPARATOR + LABEL_SUFFIX)).orElseGet(() -> Optional.ofNullable(this.getDefinitionTitle(propId)).orElse(propId)));
    }

    public String getPropertyDescription(String propId) {
        PortablePreconditions.checkNotNull((String)"propId", (Object)propId);
        return this.getValue(propId + I18N_SEPARATOR + DESCRIPTION_SUFFIX);
    }

    protected String getRuleViolationMessage(RuleViolation ruleViolation) {
        String type = ruleViolation.getClass().getName();
        Optional arguments = ruleViolation.getArguments();
        return arguments.isPresent() ? this.getValue(type, (Object[])arguments.get()) : this.getValue(type);
    }
}

