/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.core.lookup.definition;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.kie.workbench.common.stunner.core.api.DefinitionManager;
import org.kie.workbench.common.stunner.core.api.FactoryManager;
import org.kie.workbench.common.stunner.core.definition.adapter.DefinitionAdapter;
import org.kie.workbench.common.stunner.core.lookup.criteria.AbstractCriteriaLookupManager;
import org.kie.workbench.common.stunner.core.lookup.definition.DefinitionLookupManager;
import org.kie.workbench.common.stunner.core.lookup.definition.DefinitionLookupRequest;
import org.kie.workbench.common.stunner.core.lookup.definition.DefinitionRepresentation;
import org.kie.workbench.common.stunner.core.registry.impl.DefinitionsCacheRegistry;
import org.kie.workbench.common.stunner.core.util.DefinitionUtils;

@ApplicationScoped
public class DefinitionLookupManagerImpl
extends AbstractCriteriaLookupManager<String, DefinitionRepresentation, DefinitionLookupRequest>
implements DefinitionLookupManager {
    private final DefinitionManager definitionManager;
    private final FactoryManager factoryManager;
    private final DefinitionsCacheRegistry registry;

    protected DefinitionLookupManagerImpl() {
        this.definitionManager = null;
        this.factoryManager = null;
        this.registry = null;
    }

    @Inject
    public DefinitionLookupManagerImpl(DefinitionManager definitionManager, FactoryManager factoryManager, DefinitionsCacheRegistry registry) {
        this.definitionManager = definitionManager;
        this.factoryManager = factoryManager;
        this.registry = registry;
    }

    protected List<String> getItems(DefinitionLookupRequest request) {
        String defSetId = request.getDefinitionSetId();
        Object defSet = this.definitionManager.definitionSets().getDefinitionSetById(defSetId);
        if (null != defSet) {
            Set defs = this.definitionManager.adapters().forDefinitionSet().getDefinitions(defSet);
            return new LinkedList<String>(defs);
        }
        return Collections.emptyList();
    }

    protected DefinitionRepresentation buildResult(String defId) {
        Object def = this.getDomainObject(defId);
        return this.buildRepresentation(defId, def);
    }

    @Override
    protected boolean matches(String key, String value, String defId) {
        Object def = this.getDomainObject(defId);
        DefinitionAdapter definitionAdapter = this.definitionManager.adapters().registry().getDefinitionAdapter(def.getClass());
        switch (key) {
            case "id": {
                return defId.equals(value);
            }
            case "type": {
                boolean isNode = this.isNode(def, (DefinitionAdapter<Object>)definitionAdapter);
                return "node".equals(value) && isNode;
            }
            case "labels": {
                Set<String> labelSet = this.toSet(value);
                if (null != labelSet) {
                    Set defLabels = definitionAdapter.getLabels(def);
                    return DefinitionLookupManagerImpl.isIntersect(labelSet, defLabels);
                }
                return true;
            }
        }
        throw new UnsupportedOperationException("Cannot filter definitions by key [" + key + "]");
    }

    private Object getDomainObject(String id) {
        return this.registry.getDefinitionById(id);
    }

    private DefinitionRepresentation buildRepresentation(String id, Object def) {
        DefinitionAdapter definitionAdapter = this.definitionManager.adapters().registry().getDefinitionAdapter(def.getClass());
        Set labels = definitionAdapter.getLabels(def);
        boolean isNode = this.isNode(def, (DefinitionAdapter<Object>)definitionAdapter);
        return new DefinitionRepresentation(id, isNode, labels);
    }

    private boolean isNode(Object def, DefinitionAdapter<Object> definitionAdapter) {
        Class elemFactoryType = definitionAdapter.getGraphFactoryType(def);
        return DefinitionUtils.isNodeFactory(elemFactoryType, this.factoryManager.registry());
    }
}

