/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.core.lookup.rule;

import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.kie.workbench.common.stunner.core.api.DefinitionManager;
import org.kie.workbench.common.stunner.core.lookup.criteria.AbstractCriteriaLookupManager;
import org.kie.workbench.common.stunner.core.lookup.rule.RuleLookupManager;
import org.kie.workbench.common.stunner.core.lookup.rule.RuleLookupRequest;
import org.kie.workbench.common.stunner.core.rule.Rule;
import org.kie.workbench.common.stunner.core.rule.context.EdgeCardinalityContext;
import org.kie.workbench.common.stunner.core.rule.impl.CanConnect;
import org.kie.workbench.common.stunner.core.rule.impl.CanContain;
import org.kie.workbench.common.stunner.core.rule.impl.EdgeOccurrences;
import org.kie.workbench.common.stunner.core.rule.impl.Occurrences;

@ApplicationScoped
public class RuleLookupManagerImpl
extends AbstractCriteriaLookupManager<Rule, Rule, RuleLookupRequest>
implements RuleLookupManager {
    private static final String TYPE = "type";
    private static final String ROLES = "roles";
    private static final String ID = "id";
    private static final String ROLE = "role";
    private static final String ROLE_IN = "roleIn";
    private static final String EDGE_TYPE = "edgeType";
    private static final String FROM = "from";
    private static final String TO = "to";
    private static final String INCOMING = "incoming";
    private static final String CONTAINMENT = "containment";
    private static final String CONNECTION = "connection";
    private static final String CARDINALITY = "cardinality";
    private static final String EDGECARDINALITY = "edgecardinality";
    private final DefinitionManager definitionManager;

    protected RuleLookupManagerImpl() {
        this(null);
    }

    @Inject
    public RuleLookupManagerImpl(DefinitionManager definitionManager) {
        this.definitionManager = definitionManager;
    }

    protected List<Rule> getItems(RuleLookupRequest request) {
        String defSetId = request.getDefinitionSetId();
        Object defSet = this.definitionManager.definitionSets().getDefinitionSetById(defSetId);
        if (null != defSet) {
            Collection rules = this.definitionManager.adapters().forRules().getRuleSet(defSet).getRules();
            return new LinkedList<Rule>(rules);
        }
        return null;
    }

    protected Rule buildResult(Rule rule) {
        return rule;
    }

    @Override
    protected boolean matches(String key, String value, Rule rule) {
        switch (key) {
            case "type": {
                return CONTAINMENT.equals(value) && rule instanceof CanContain || CONNECTION.equals(value) && rule instanceof CanConnect || CARDINALITY.equals(value) && rule instanceof Occurrences || EDGECARDINALITY.equals(value) && rule instanceof EdgeOccurrences;
            }
            case "roles": {
                try {
                    CanContain cr = (CanContain)rule;
                    Set<String> rolesSet = this.toSet(value);
                    if (null != rolesSet) {
                        return RuleLookupManagerImpl.isIntersect(cr.getAllowedRoles(), rolesSet);
                    }
                }
                catch (ClassCastException e) {
                    return false;
                }
                return true;
            }
            case "id": {
                String _id = null;
                if (rule instanceof CanContain) {
                    CanContain er = (CanContain)rule;
                    _id = er.getRole();
                } else if (rule instanceof CanConnect) {
                    CanConnect er = (CanConnect)rule;
                    _id = er.getRole();
                }
                return _id != null && _id.equals(value);
            }
            case "role": {
                if (rule instanceof EdgeOccurrences) {
                    EdgeOccurrences er = (EdgeOccurrences)rule;
                    return er.getRole().equals(value);
                }
                return false;
            }
            case "roleIn": {
                if (rule instanceof EdgeOccurrences) {
                    EdgeOccurrences er = (EdgeOccurrences)rule;
                    Set<String> set = this.toSet(value);
                    if (null != set && !set.isEmpty()) {
                        for (String s : set) {
                            if (!er.getRole().equals(value)) continue;
                            return true;
                        }
                    }
                }
                return false;
            }
            case "edgeType": {
                try {
                    EdgeOccurrences er = (EdgeOccurrences)rule;
                    return er.getDirection().equals((Object)(INCOMING.equals(value) ? EdgeCardinalityContext.Direction.INCOMING : EdgeCardinalityContext.Direction.OUTGOING));
                }
                catch (ClassCastException e) {
                    return false;
                }
            }
            case "from": 
            case "to": {
                try {
                    CanConnect cr = (CanConnect)rule;
                    Set<String> fromSet = this.toSet(value);
                    Set<String> ruleSet = this.getRoles(cr.getPermittedConnections(), FROM.equals(key));
                    if (null != fromSet) {
                        return RuleLookupManagerImpl.isIntersect(fromSet, ruleSet);
                    }
                    break;
                }
                catch (Exception e) {
                    return false;
                }
            }
        }
        throw new UnsupportedOperationException("Cannot filter rules by key [" + key + "]");
    }

    private Set<String> getRoles(List<CanConnect.PermittedConnection> connections, boolean from) {
        if (null != connections) {
            HashSet<String> result = new HashSet<String>(connections.size());
            for (CanConnect.PermittedConnection c : connections) {
                if (from) {
                    result.add(c.getStartRole());
                    continue;
                }
                result.add(c.getEndRole());
            }
            return result;
        }
        return null;
    }
}

