/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.core.profile;

import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.kie.workbench.common.stunner.core.api.DefinitionManager;
import org.kie.workbench.common.stunner.core.api.ProfileManager;
import org.kie.workbench.common.stunner.core.diagram.Metadata;
import org.kie.workbench.common.stunner.core.profile.DomainProfile;
import org.kie.workbench.common.stunner.core.profile.FullProfile;
import org.kie.workbench.common.stunner.core.profile.Profile;

@ApplicationScoped
public class DomainProfileManager {
    private final DefinitionManager definitionManager;
    private final ProfileManager profileManager;
    private final FullProfile defaultProfile;

    @Inject
    public DomainProfileManager(DefinitionManager definitionManager, ProfileManager profileManager, FullProfile defaultProfile) {
        this.definitionManager = definitionManager;
        this.profileManager = profileManager;
        this.defaultProfile = defaultProfile;
    }

    public List<String> getAllDefinitions(Metadata metadata) {
        return this.getDefinitionsByProfile(metadata.getDefinitionSetId(), metadata.getProfileId());
    }

    public Predicate<String> isDefinitionIdAllowed(Metadata metadata) {
        return this.getDefinitionProfile(metadata).map(DomainProfile::definitionAllowedFilter).orElse(this.defaultProfile.definitionAllowedFilter());
    }

    private Optional<DomainProfile> getDefinitionProfile(Metadata metadata) {
        return this.getDefinitionProfile(metadata.getDefinitionSetId(), metadata.getProfileId());
    }

    private List<String> getDefinitionsByProfile(String definitionSetId, String profileId) {
        Object definitionSet = this.definitionManager.definitionSets().getDefinitionSetById(definitionSetId);
        Set definitions = this.definitionManager.adapters().forDefinitionSet().getDefinitions(definitionSet);
        return this.getDefinitionProfile(definitionSetId, profileId).map(profile -> definitions.stream().filter(profile.definitionAllowedFilter())).orElse(definitions.stream()).collect(Collectors.toList());
    }

    private Optional<DomainProfile> getDefinitionProfile(String definitionSetId, String profileId) {
        Profile profile = this.profileManager.getProfile(definitionSetId, profileId);
        if (profile instanceof DomainProfile) {
            return Optional.of((DomainProfile)profile);
        }
        return Optional.empty();
    }
}

