/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.core.registry.impl;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.kie.workbench.common.stunner.core.registry.rule.RuleHandlerRegistry;
import org.kie.workbench.common.stunner.core.rule.RuleEvaluationHandler;
import org.kie.workbench.common.stunner.core.rule.ext.RuleExtensionHandler;

public class RuleHandlerRegistryImpl
implements RuleHandlerRegistry {
    private final Map<Class<?>, List<RuleEvaluationHandler>> handlers = new HashMap(15);
    private final Map<Class<?>, RuleExtensionHandler> extensionHandlers = new LinkedHashMap();

    public void register(RuleEvaluationHandler handler) {
        if (handler instanceof RuleExtensionHandler) {
            this.addExtension((RuleExtensionHandler)handler);
        } else {
            this.addHandler(handler);
        }
    }

    public Collection<RuleEvaluationHandler> getHandlersByContext(Class<?> contextType) {
        return this.handlers.getOrDefault(contextType, Collections.emptyList());
    }

    public <T extends RuleExtensionHandler> T getExtensionHandler(Class<T> contextType) {
        return (T)this.extensionHandlers.get(contextType);
    }

    public void clear() {
        this.handlers.clear();
        this.extensionHandlers.clear();
    }

    public boolean isEmpty() {
        return this.handlers.isEmpty() && this.extensionHandlers.isEmpty();
    }

    public boolean remove(RuleEvaluationHandler item) {
        throw new UnsupportedOperationException("Not yet implemented");
    }

    public boolean contains(RuleEvaluationHandler item) {
        throw new UnsupportedOperationException("Not yet implemented");
    }

    private void addHandler(RuleEvaluationHandler handler) {
        Class contextType = handler.getContextType();
        List<RuleEvaluationHandler> ruleEvaluationHandlers = this.handlers.get(contextType);
        if (null == ruleEvaluationHandlers) {
            ruleEvaluationHandlers = new LinkedList<RuleEvaluationHandler>();
            this.handlers.put(contextType, ruleEvaluationHandlers);
        }
        ruleEvaluationHandlers.add(handler);
    }

    private void addExtension(RuleExtensionHandler handler) {
        this.extensionHandlers.put(handler.getExtensionType(), handler);
    }
}

