/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.core.util;

import java.util.HashSet;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.kie.workbench.common.stunner.core.command.CommandResult;
import org.kie.workbench.common.stunner.core.definition.adapter.binding.BindableAdapterUtils;
import org.kie.workbench.common.stunner.core.graph.Edge;
import org.kie.workbench.common.stunner.core.graph.Graph;
import org.kie.workbench.common.stunner.core.graph.Node;
import org.kie.workbench.common.stunner.core.graph.content.Bounds;
import org.kie.workbench.common.stunner.core.graph.content.definition.DefinitionSet;
import org.kie.workbench.common.stunner.core.graph.content.relationship.Child;
import org.kie.workbench.common.stunner.core.graph.content.view.Connection;
import org.kie.workbench.common.stunner.core.graph.content.view.DiscreteConnection;
import org.kie.workbench.common.stunner.core.graph.content.view.View;
import org.kie.workbench.common.stunner.core.graph.content.view.ViewConnector;
import org.kie.workbench.common.stunner.core.graph.processing.traverse.content.AbstractFullContentTraverseCallback;
import org.kie.workbench.common.stunner.core.graph.processing.traverse.content.FullContentTraverseCallback;
import org.kie.workbench.common.stunner.core.graph.processing.traverse.content.FullContentTraverseProcessorImpl;
import org.kie.workbench.common.stunner.core.graph.processing.traverse.tree.TreeWalkTraverseProcessorImpl;
import org.kie.workbench.common.stunner.core.rule.RuleViolation;

public class StunnerLogger {
    private static Logger LOGGER = Logger.getLogger(StunnerLogger.class.getName());
    private static final FullContentTraverseCallback<Node<View, Edge>, Edge<Object, Node>> TREE_TRAVERSE_CALLBACK = new AbstractFullContentTraverseCallback<Node<View, Edge>, Edge<Object, Node>>(){
        private String indent = "";

        @Override
        public void startViewEdgeTraversal(Edge<Object, Node> edge) {
            Node outNode;
            StunnerLogger.log(this.indent + "(View) Edge UUID: " + edge.getUUID());
            View viewContent = (View)edge.getContent();
            String dId = StunnerLogger.getDefinitionId(viewContent.getDefinition());
            StunnerLogger.log(this.indent + "(View) Edge Id: " + dId);
            if (viewContent instanceof ViewConnector) {
                StunnerLogger.log((ViewConnector)viewContent);
            }
            if ((outNode = edge.getTargetNode()) == null) {
                StunnerLogger.log(this.indent + "  No outgoing node found");
            } else {
                StunnerLogger.log(this.indent + "  Outgoing Node");
                StunnerLogger.log(this.indent + "  ==============");
            }
        }

        @Override
        public void startChildEdgeTraversal(Edge<Object, Node> edge) {
            StunnerLogger.log("(Child= Edge UUID: " + edge.getUUID());
            Node outNode = edge.getTargetNode();
            if (outNode == null) {
                StunnerLogger.log(this.indent + "  No outgoing node found");
            } else {
                StunnerLogger.log(this.indent + "  Outgoing Node");
                StunnerLogger.log(this.indent + "  ==============");
            }
        }

        @Override
        public void startParentEdgeTraversal(Edge<Object, Node> edge) {
        }

        @Override
        public void startEdgeTraversal(Edge<Object, Node> edge) {
            StunnerLogger.log(this.indent + "Edge UUID: " + edge.getUUID());
            Object content = edge.getContent();
            StunnerLogger.log("  Edge Content: " + content.getClass().getName());
            Node outNode = edge.getTargetNode();
            if (outNode == null) {
                StunnerLogger.log(this.indent + "  No outgoing node found");
            } else {
                StunnerLogger.log(this.indent + "  Outgoing Node");
                StunnerLogger.log(this.indent + "  ==============");
            }
        }

        @Override
        public void startGraphTraversal(Graph<DefinitionSet, Node<View, Edge>> graph) {
            if (graph == null) {
                StunnerLogger.error("Graph is null!");
            } else {
                DefinitionSet view = (DefinitionSet)graph.getContent();
                StunnerLogger.log(this.indent + "Graph UUID: " + graph.getUUID());
                StunnerLogger.log(this.indent + "  Graph Starting nodes");
                StunnerLogger.log(this.indent + "  ====================");
            }
        }

        @Override
        public void startNodeTraversal(Node<View, Edge> node) {
            HashSet outEdges;
            StunnerLogger.log(this.indent + "(View) Node UUID: " + node.getUUID());
            View view = (View)node.getContent();
            String nId = StunnerLogger.getDefinitionId(view.getDefinition());
            Bounds bounds = view.getBounds();
            StunnerLogger.log(this.indent + "(View) Node Id: " + nId);
            StunnerLogger.log(this.indent + "(View) Node Bounds: " + bounds);
            Node parent = StunnerLogger.getParent(node);
            if (null != parent) {
                StunnerLogger.log(this.indent + "(View) Node Parent is: " + parent.getUUID());
            }
            if ((outEdges = new HashSet(node.getOutEdges())).isEmpty()) {
                StunnerLogger.log(this.indent + "  No outgoing edges found");
            } else {
                StunnerLogger.log(this.indent + "  Outgoing edges");
                StunnerLogger.log(this.indent + "  ==============");
            }
        }

        @Override
        public void endGraphTraversal() {
        }
    };

    private static String getDefinitionId(Object o) {
        return BindableAdapterUtils.getDefinitionId(o.getClass());
    }

    public static void logCommandResults(Iterable<CommandResult> results) {
        if (results == null) {
            StunnerLogger.log("Results is null");
        } else {
            for (CommandResult result : results) {
                StunnerLogger.logCommandResult(result);
            }
        }
    }

    public static void logCommandResult(CommandResult result) {
        StunnerLogger.log("Command Result [type=" + result.getType() + ",result=" + result + "]");
        StunnerLogger.logRuleViolations(result.getViolations());
    }

    public static void logRuleViolations(Iterable<RuleViolation> violations) {
        if (violations == null) {
            StunnerLogger.log("Violations is null");
        } else {
            for (RuleViolation result : violations) {
                StunnerLogger.logRuleViolation(result);
            }
        }
    }

    public static void logRuleViolation(RuleViolation violation) {
        StunnerLogger.log("Rule Violation [type=" + violation.getViolationType() + "] [violation" + violation);
    }

    private static Node getParent(Node node) {
        List inEdges = node.getInEdges();
        if (null != inEdges && !inEdges.isEmpty()) {
            for (Edge edge : inEdges) {
                if (!(edge.getContent() instanceof Child)) continue;
                return edge.getSourceNode();
            }
        }
        return null;
    }

    public static void log(Graph graph) {
        if (null != graph) {
            new FullContentTraverseProcessorImpl(new TreeWalkTraverseProcessorImpl()).traverse((Graph<View, Node<View, Edge>>)graph, TREE_TRAVERSE_CALLBACK);
        }
    }

    public static void log(Node<View, Edge> node) {
        if (null == node) {
            StunnerLogger.log("Node is null");
        } else {
            HashSet outEdges;
            StunnerLogger.log("(View) Node UUID: " + node.getUUID());
            View view = (View)node.getContent();
            String nId = StunnerLogger.getDefinitionId(view.getDefinition());
            Bounds bounds = view.getBounds();
            StunnerLogger.log("(View) Node Id: " + nId);
            StunnerLogger.log("(View) Node Bounds: " + bounds);
            Node parent = StunnerLogger.getParent(node);
            if (null != parent) {
                StunnerLogger.log("(View) Node Parent is: " + parent.getUUID());
            }
            if ((outEdges = new HashSet(node.getOutEdges())).isEmpty()) {
                StunnerLogger.log("No outgoing edges found");
            } else {
                StunnerLogger.log("Outgoing edges");
                StunnerLogger.log("==============");
                for (Edge edge : outEdges) {
                    StunnerLogger.log(edge);
                }
            }
            HashSet inEdges = new HashSet(node.getInEdges());
            if (inEdges.isEmpty()) {
                StunnerLogger.log("No incoming edges found");
            } else {
                StunnerLogger.log("incoming edges");
                StunnerLogger.log("==============");
                for (Edge edge : inEdges) {
                    StunnerLogger.log(edge);
                }
            }
        }
    }

    public static void log(Edge<?, Node> edge) {
        StunnerLogger.log("Edge UUID: " + edge.getUUID());
        Object content = edge.getContent();
        StunnerLogger.log("  Edge Content: " + content.getClass().getName());
        Node inNode = edge.getSourceNode();
        Node outNode = edge.getTargetNode();
        StunnerLogger.log("  Edge In Node: " + (null != inNode ? inNode.getUUID() : "null"));
        StunnerLogger.log("  Edge Out Node: " + (null != outNode ? outNode.getUUID() : "null"));
        if (edge.getContent() instanceof ViewConnector) {
            StunnerLogger.log((ViewConnector)edge.getContent());
        }
    }

    public static void log(ViewConnector viewConnector) {
        viewConnector.getSourceConnection().ifPresent(connection -> StunnerLogger.log("source", (Connection)connection));
        viewConnector.getTargetConnection().ifPresent(connection -> StunnerLogger.log("target", (Connection)connection));
    }

    public static void log(String type, Connection connection) {
        String discrete = "";
        if (connection instanceof DiscreteConnection) {
            DiscreteConnection discreteConnection = (DiscreteConnection)connection;
            discrete = discrete + "[index=" + discreteConnection.getMagnetIndex() + ", auto=" + discreteConnection.isAuto() + "]";
        }
        StunnerLogger.log("  Connection [" + type + "] at [" + connection.getLocation() + "] " + discrete);
    }

    private static void log(String message) {
        LOGGER.log(Level.INFO, message);
    }

    private static void error(String message) {
        LOGGER.log(Level.SEVERE, message);
    }
}

