/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.CinderVolumeSource;
import io.fabric8.kubernetes.api.model.CinderVolumeSourceFluent;
import io.fabric8.kubernetes.api.model.LocalObjectReference;
import io.fabric8.kubernetes.api.model.LocalObjectReferenceBuilder;
import io.fabric8.kubernetes.api.model.LocalObjectReferenceFluentImpl;

public class CinderVolumeSourceFluentImpl<A extends CinderVolumeSourceFluent<A>>
extends BaseFluent<A>
implements CinderVolumeSourceFluent<A> {
    private String fsType;
    private Boolean readOnly;
    private LocalObjectReferenceBuilder secretRef;
    private String volumeID;

    public CinderVolumeSourceFluentImpl() {
    }

    public CinderVolumeSourceFluentImpl(CinderVolumeSource instance) {
        this.withFsType(instance.getFsType());
        this.withReadOnly(instance.getReadOnly());
        this.withSecretRef(instance.getSecretRef());
        this.withVolumeID(instance.getVolumeID());
    }

    @Override
    public String getFsType() {
        return this.fsType;
    }

    @Override
    public A withFsType(String fsType) {
        this.fsType = fsType;
        return (A)this;
    }

    @Override
    public Boolean hasFsType() {
        return this.fsType != null;
    }

    @Override
    public A withNewFsType(String arg1) {
        return this.withFsType(new String(arg1));
    }

    @Override
    public A withNewFsType(StringBuilder arg1) {
        return this.withFsType(new String(arg1));
    }

    @Override
    public A withNewFsType(StringBuffer arg1) {
        return this.withFsType(new String(arg1));
    }

    @Override
    public Boolean isReadOnly() {
        return this.readOnly;
    }

    @Override
    public A withReadOnly(Boolean readOnly) {
        this.readOnly = readOnly;
        return (A)this;
    }

    @Override
    public Boolean hasReadOnly() {
        return this.readOnly != null;
    }

    @Override
    public A withNewReadOnly(String arg1) {
        return this.withReadOnly(new Boolean(arg1));
    }

    @Override
    public A withNewReadOnly(boolean arg1) {
        return this.withReadOnly(new Boolean(arg1));
    }

    @Override
    @Deprecated
    public LocalObjectReference getSecretRef() {
        return this.secretRef != null ? this.secretRef.build() : null;
    }

    @Override
    public LocalObjectReference buildSecretRef() {
        return this.secretRef != null ? this.secretRef.build() : null;
    }

    @Override
    public A withSecretRef(LocalObjectReference secretRef) {
        this._visitables.get("secretRef").remove(this.secretRef);
        if (secretRef != null) {
            this.secretRef = new LocalObjectReferenceBuilder(secretRef);
            this._visitables.get("secretRef").add(this.secretRef);
        }
        return (A)this;
    }

    @Override
    public Boolean hasSecretRef() {
        return this.secretRef != null;
    }

    @Override
    public A withNewSecretRef(String name) {
        return this.withSecretRef(new LocalObjectReference(name));
    }

    @Override
    public CinderVolumeSourceFluent.SecretRefNested<A> withNewSecretRef() {
        return new SecretRefNestedImpl();
    }

    @Override
    public CinderVolumeSourceFluent.SecretRefNested<A> withNewSecretRefLike(LocalObjectReference item) {
        return new SecretRefNestedImpl(item);
    }

    @Override
    public CinderVolumeSourceFluent.SecretRefNested<A> editSecretRef() {
        return this.withNewSecretRefLike(this.getSecretRef());
    }

    @Override
    public CinderVolumeSourceFluent.SecretRefNested<A> editOrNewSecretRef() {
        return this.withNewSecretRefLike(this.getSecretRef() != null ? this.getSecretRef() : new LocalObjectReferenceBuilder().build());
    }

    @Override
    public CinderVolumeSourceFluent.SecretRefNested<A> editOrNewSecretRefLike(LocalObjectReference item) {
        return this.withNewSecretRefLike(this.getSecretRef() != null ? this.getSecretRef() : item);
    }

    @Override
    public String getVolumeID() {
        return this.volumeID;
    }

    @Override
    public A withVolumeID(String volumeID) {
        this.volumeID = volumeID;
        return (A)this;
    }

    @Override
    public Boolean hasVolumeID() {
        return this.volumeID != null;
    }

    @Override
    public A withNewVolumeID(String arg1) {
        return this.withVolumeID(new String(arg1));
    }

    @Override
    public A withNewVolumeID(StringBuilder arg1) {
        return this.withVolumeID(new String(arg1));
    }

    @Override
    public A withNewVolumeID(StringBuffer arg1) {
        return this.withVolumeID(new String(arg1));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        CinderVolumeSourceFluentImpl that = (CinderVolumeSourceFluentImpl)o;
        if (this.fsType != null ? !this.fsType.equals(that.fsType) : that.fsType != null) {
            return false;
        }
        if (this.readOnly != null ? !this.readOnly.equals(that.readOnly) : that.readOnly != null) {
            return false;
        }
        if (this.secretRef != null ? !this.secretRef.equals(that.secretRef) : that.secretRef != null) {
            return false;
        }
        return !(this.volumeID != null ? !this.volumeID.equals(that.volumeID) : that.volumeID != null);
    }

    public class SecretRefNestedImpl<N>
    extends LocalObjectReferenceFluentImpl<CinderVolumeSourceFluent.SecretRefNested<N>>
    implements CinderVolumeSourceFluent.SecretRefNested<N>,
    Nested<N> {
        private final LocalObjectReferenceBuilder builder;

        SecretRefNestedImpl(LocalObjectReference item) {
            this.builder = new LocalObjectReferenceBuilder(this, item);
        }

        SecretRefNestedImpl() {
            this.builder = new LocalObjectReferenceBuilder(this);
        }

        @Override
        public N and() {
            return (N)CinderVolumeSourceFluentImpl.this.withSecretRef(this.builder.build());
        }

        @Override
        public N endSecretRef() {
            return this.and();
        }
    }
}

