/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.core.backend.definition.adapter.bind;

import java.lang.reflect.Field;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import org.kie.workbench.common.stunner.core.backend.definition.adapter.AbstractReflectAdapter;
import org.kie.workbench.common.stunner.core.definition.adapter.binding.BindableAdapterUtils;
import org.kie.workbench.common.stunner.core.definition.adapter.binding.BindablePropertyAdapter;
import org.kie.workbench.common.stunner.core.definition.property.PropertyType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class BackendBindablePropertyAdapter<T, V>
extends AbstractReflectAdapter<T>
implements BindablePropertyAdapter<T, V> {
    private static final Logger LOG = LoggerFactory.getLogger(BackendBindablePropertyAdapter.class);
    private Map<Class, String> propertyTypeFieldNames;
    private Map<Class, PropertyType> propertyTypes;
    private Map<Class, String> propertyCaptionFieldNames;
    private Map<Class, String> propertyDescriptionFieldNames;
    private Map<Class, String> propertyReadOnlyFieldNames;
    private Map<Class, String> propertyOptionalFieldNames;
    private Map<Class, String> propertyValueFieldNames;
    private Map<Class, String> propertyAllowedValuesFieldNames;

    BackendBindablePropertyAdapter() {
    }

    public void setBindings(Map<Class, String> propertyTypeFieldNames, Map<Class, PropertyType> propertyTypes, Map<Class, String> propertyCaptionFieldNames, Map<Class, String> propertyDescriptionFieldNames, Map<Class, String> propertyReadOnlyFieldNames, Map<Class, String> propertyOptionalFieldNames, Map<Class, String> propertyValueFieldNames, Map<Class, String> propertyAllowedValuesFieldNames) {
        this.propertyTypeFieldNames = propertyTypeFieldNames;
        this.propertyTypes = propertyTypes;
        this.propertyCaptionFieldNames = propertyCaptionFieldNames;
        this.propertyDescriptionFieldNames = propertyDescriptionFieldNames;
        this.propertyReadOnlyFieldNames = propertyReadOnlyFieldNames;
        this.propertyOptionalFieldNames = propertyOptionalFieldNames;
        this.propertyValueFieldNames = propertyValueFieldNames;
        this.propertyAllowedValuesFieldNames = propertyAllowedValuesFieldNames;
    }

    public String getId(T property) {
        return BindableAdapterUtils.getPropertyId(property.getClass());
    }

    public PropertyType getType(T property) {
        Class<?> type = property.getClass();
        PropertyType pType = null;
        try {
            pType = (PropertyType)this.getFieldValue(property, this.propertyTypeFieldNames.get(type));
            if (null == pType) {
                pType = this.propertyTypes.get(type);
            }
        }
        catch (IllegalAccessException e) {
            LOG.error("Error obtaining type for Property with id " + this.getId(property));
        }
        return pType;
    }

    public String getCaption(T property) {
        Class<?> type = property.getClass();
        try {
            return (String)this.getFieldValue(property, this.propertyCaptionFieldNames.get(type));
        }
        catch (IllegalAccessException e) {
            LOG.error("Error obtaining caption for Property with id " + this.getId(property));
            return null;
        }
    }

    public String getDescription(T property) {
        Class<?> type = property.getClass();
        try {
            return (String)this.getFieldValue(property, this.propertyDescriptionFieldNames.get(type));
        }
        catch (IllegalAccessException e) {
            LOG.error("Error obtaining description for Property with id " + this.getId(property));
            return null;
        }
    }

    public boolean isReadOnly(T property) {
        Class<?> type = property.getClass();
        try {
            return (Boolean)this.getFieldValue(property, this.propertyReadOnlyFieldNames.get(type));
        }
        catch (IllegalAccessException e) {
            LOG.error("Error obtaining read only flag for Property with id " + this.getId(property));
            return false;
        }
    }

    public boolean isOptional(T property) {
        Class<?> type = property.getClass();
        try {
            return (Boolean)this.getFieldValue(property, this.propertyOptionalFieldNames.get(type));
        }
        catch (IllegalAccessException e) {
            LOG.error("Error obtaining optional flag for Property with id " + this.getId(property));
            return true;
        }
    }

    public V getValue(T property) {
        Class<?> type = property.getClass();
        try {
            return this.getFieldValue(property, this.propertyValueFieldNames.get(type));
        }
        catch (IllegalAccessException e) {
            LOG.error("Error obtaining value for Property with id " + this.getId(property));
            return null;
        }
    }

    public Map<V, String> getAllowedValues(T property) {
        Class<?> type = property.getClass();
        String field = this.propertyAllowedValuesFieldNames.get(type);
        Iterable allowedValues = null;
        try {
            allowedValues = (Iterable)this.getFieldValue(property, field);
        }
        catch (IllegalAccessException e) {
            LOG.error("Error obtaining allowed values for Property with id " + this.getId(property));
        }
        if (null != allowedValues && allowedValues.iterator().hasNext()) {
            LinkedHashMap result = new LinkedHashMap();
            Iterator iterator = allowedValues.iterator();
            while (iterator.hasNext()) {
                Object v;
                Object allowedValue = v = iterator.next();
                result.put(allowedValue, allowedValue.toString());
            }
            return result;
        }
        return null;
    }

    public void setValue(T property, V value) {
        Class<?> type = property.getClass();
        String fieldName = this.propertyValueFieldNames.get(type);
        Field field = null;
        try {
            field = this.getField(property, fieldName);
        }
        catch (IllegalAccessException e) {
            LOG.error("Error setting value for Property with id " + this.getId(property) + ". Field [" + fieldName + "] not found for type [" + type.getName() + "]");
        }
        if (null != field) {
            try {
                field.setAccessible(true);
                field.set(property, value);
            }
            catch (Exception e) {
                LOG.error("Error setting value for Property with id [" + this.getId(property) + "] and value [" + (value != null ? value.toString() : "null") + "]");
            }
        }
    }

    public boolean accepts(Class<?> type) {
        return null != this.propertyValueFieldNames && this.propertyValueFieldNames.containsKey(type);
    }
}

