/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.core.backend.definition.adapter.reflect;

import java.lang.reflect.Field;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.enterprise.context.Dependent;
import org.kie.workbench.common.stunner.core.backend.definition.adapter.AbstractReflectAdapter;
import org.kie.workbench.common.stunner.core.backend.definition.adapter.ReflectionAdapterUtils;
import org.kie.workbench.common.stunner.core.definition.adapter.PropertyAdapter;
import org.kie.workbench.common.stunner.core.definition.adapter.binding.BindableAdapterUtils;
import org.kie.workbench.common.stunner.core.definition.annotation.Description;
import org.kie.workbench.common.stunner.core.definition.annotation.Property;
import org.kie.workbench.common.stunner.core.definition.annotation.property.AllowedValues;
import org.kie.workbench.common.stunner.core.definition.annotation.property.Caption;
import org.kie.workbench.common.stunner.core.definition.annotation.property.Optional;
import org.kie.workbench.common.stunner.core.definition.annotation.property.ReadOnly;
import org.kie.workbench.common.stunner.core.definition.annotation.property.Type;
import org.kie.workbench.common.stunner.core.definition.annotation.property.Value;
import org.kie.workbench.common.stunner.core.definition.property.PropertyType;
import org.kie.workbench.common.stunner.core.util.DefinitionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Dependent
public class BackendPropertyAdapter<T>
extends AbstractReflectAdapter<T>
implements PropertyAdapter<T, Object> {
    private static final Logger LOG = LoggerFactory.getLogger(BackendPropertyAdapter.class);

    public String getId(T property) {
        return BindableAdapterUtils.getPropertyId(property.getClass());
    }

    public PropertyType getType(T property) {
        PropertyType pType = null;
        try {
            Class<?> valueType;
            Class defaultPropertyType;
            Collection<Field> valueFields;
            pType = (PropertyType)this.getAnnotatedFieldValue(property, Type.class);
            if (null == pType && null != (valueFields = ReflectionAdapterUtils.getFieldAnnotations(property.getClass(), Value.class)) && !valueFields.isEmpty() && null != (defaultPropertyType = DefinitionUtils.getDefaultPropertyType(valueType = valueFields.iterator().next().getType()))) {
                pType = (PropertyType)defaultPropertyType.newInstance();
            }
        }
        catch (Exception e) {
            LOG.error("Error obtaining annotated category for Property with id " + this.getId(property));
        }
        if (null == pType) {
            LOG.error("No property type specified for Property with id " + this.getId(property));
        }
        return pType;
    }

    public String getCaption(T property) {
        try {
            return (String)this.getAnnotatedFieldValue(property, Caption.class);
        }
        catch (Exception e) {
            LOG.error("Error obtaining annotated category for Property with id " + this.getId(property));
            return null;
        }
    }

    public String getDescription(T property) {
        try {
            return (String)this.getAnnotatedFieldValue(property, Description.class);
        }
        catch (Exception e) {
            LOG.error("Error obtaining annotated category for Property with id " + this.getId(property));
            return BindableAdapterUtils.toSimpleName(property);
        }
    }

    public boolean isReadOnly(T property) {
        try {
            Boolean value = (Boolean)this.getAnnotatedFieldValue(property, ReadOnly.class);
            return null != value ? value : false;
        }
        catch (Exception e) {
            LOG.error("Error obtaining annotated category for Property with id " + this.getId(property));
            return false;
        }
    }

    public boolean isOptional(T property) {
        try {
            Boolean value = (Boolean)this.getAnnotatedFieldValue(property, Optional.class);
            return null != value ? value : true;
        }
        catch (Exception e) {
            LOG.error("Error obtaining annotated category for Property with id " + this.getId(property));
            return true;
        }
    }

    public Object getValue(T property) {
        if (null != property) {
            Class<Object> c = property.getClass();
            while (!c.isAssignableFrom(Object.class)) {
                Field[] fields = c.getDeclaredFields();
                if (null != fields) {
                    for (Field field : fields) {
                        Value annotation = field.getAnnotation(Value.class);
                        if (null == annotation) continue;
                        try {
                            return this._getValue(field, annotation, property);
                        }
                        catch (Exception e) {
                            LOG.error("Error obtaining annotated value for Property with id " + this.getId(property), (Throwable)e);
                        }
                    }
                }
                c = c.getSuperclass();
            }
        }
        return null;
    }

    public Map<Object, String> getAllowedValues(T property) {
        LinkedHashMap<Object, String> result = new LinkedHashMap<Object, String>();
        if (null != property) {
            Class<Object> c = property.getClass();
            boolean done = false;
            while (!done && !c.isAssignableFrom(Object.class)) {
                Field[] fields = c.getDeclaredFields();
                if (null != fields) {
                    for (Field field : fields) {
                        AllowedValues annotation = field.getAnnotation(AllowedValues.class);
                        if (null == annotation) continue;
                        try {
                            Iterable value = (Iterable)this._getValue(field, annotation, property);
                            if (null != value && value.iterator().hasNext()) {
                                for (Object v : value) {
                                    result.put(v, v.toString());
                                }
                            }
                            done = true;
                        }
                        catch (Exception e) {
                            LOG.error("Error obtaining annotated allowed values for Property with id " + this.getId(property));
                        }
                    }
                }
                c = c.getSuperclass();
            }
        }
        return !result.isEmpty() ? result : null;
    }

    private <V> V _getValue(Field field, Object annotation, T property) throws IllegalAccessException {
        if (null != annotation) {
            field.setAccessible(true);
            Object result = field.get(property);
            return (V)result;
        }
        return null;
    }

    public void setValue(T property, Object value) {
        if (null != property) {
            if (this.isReadOnly(property)) {
                LOG.warn("Cannot set new value for property [" + this.getId(property) + "] as it is read only! ");
                return;
            }
            Class<Object> c = property.getClass();
            boolean done = false;
            while (!done && !c.isAssignableFrom(Object.class)) {
                Field[] fields = c.getDeclaredFields();
                if (null != fields) {
                    for (Field field : fields) {
                        Value annotation = field.getAnnotation(Value.class);
                        if (null == annotation) continue;
                        try {
                            field.setAccessible(true);
                            field.set(property, value);
                            done = true;
                            break;
                        }
                        catch (Exception e) {
                            LOG.error("Error setting value for Property with id [" + this.getId(property) + "] and value [" + (value != null ? value.toString() : "null") + "]");
                        }
                    }
                }
                c = c.getSuperclass();
            }
        }
    }

    public boolean accepts(Class<?> pojo) {
        return pojo.getAnnotation(Property.class) != null;
    }
}

