/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.core.backend.definition.adapter.reflect;

import java.lang.reflect.Field;
import java.util.HashSet;
import java.util.Set;
import javax.enterprise.context.Dependent;
import org.kie.workbench.common.stunner.core.backend.definition.adapter.AbstractReflectAdapter;
import org.kie.workbench.common.stunner.core.definition.adapter.PropertySetAdapter;
import org.kie.workbench.common.stunner.core.definition.adapter.binding.BindableAdapterUtils;
import org.kie.workbench.common.stunner.core.definition.annotation.Name;
import org.kie.workbench.common.stunner.core.definition.annotation.Property;
import org.kie.workbench.common.stunner.core.definition.annotation.PropertySet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Dependent
public class BackendPropertySetAdapter<T>
extends AbstractReflectAdapter<T>
implements PropertySetAdapter<T> {
    private static final Logger LOG = LoggerFactory.getLogger(BackendPropertySetAdapter.class);

    public String getId(T propertySet) {
        return BindableAdapterUtils.getPropertySetId(propertySet.getClass());
    }

    public String getName(T propertySet) {
        try {
            return (String)this.getAnnotatedFieldValue(propertySet, Name.class);
        }
        catch (Exception e) {
            LOG.error("Error obtaining annotated category for PropertySet with id " + this.getId(propertySet));
            return null;
        }
    }

    public Set<?> getProperties(T propertySet) {
        Field[] fields;
        HashSet<Object> result = null;
        if (null != propertySet && null != (fields = propertySet.getClass().getDeclaredFields())) {
            result = new HashSet<Object>();
            for (Field field : fields) {
                Property annotation = field.getAnnotation(Property.class);
                if (null == annotation) continue;
                try {
                    field.setAccessible(true);
                    Object property = field.get(propertySet);
                    result.add(property);
                }
                catch (Exception e) {
                    LOG.error("Error obtaining annotated properties for T with id " + this.getId(propertySet));
                }
            }
        }
        return result;
    }

    public boolean accepts(Class<?> pojo) {
        return pojo.getAnnotation(PropertySet.class) != null;
    }
}

