/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.ala.ui.backend.service;

import org.guvnor.ala.services.api.RuntimeQueryResultItem;
import org.guvnor.ala.ui.model.Pipeline;
import org.guvnor.ala.ui.model.PipelineError;
import org.guvnor.ala.ui.model.PipelineExecutionTrace;
import org.guvnor.ala.ui.model.PipelineExecutionTraceKey;
import org.guvnor.ala.ui.model.PipelineKey;
import org.guvnor.ala.ui.model.PipelineStatus;
import org.guvnor.ala.ui.model.ProviderKey;
import org.guvnor.ala.ui.model.ProviderTypeKey;
import org.guvnor.ala.ui.model.Runtime;
import org.guvnor.ala.ui.model.RuntimeKey;
import org.guvnor.ala.ui.model.RuntimeListItem;
import org.guvnor.ala.ui.model.Stage;

public class RuntimeListItemBuilder {
    private static final String SCHEDULED = "SCHEDULED";
    private static final String RUNNING = "RUNNING";
    private static final String FINISHED = "FINISHED";
    private static final String ERROR = "ERROR";
    private static final String STOPPED = "STOPPED";
    private RuntimeQueryResultItem item;

    private RuntimeListItemBuilder() {
    }

    public static RuntimeListItemBuilder newInstance() {
        return new RuntimeListItemBuilder();
    }

    public RuntimeListItemBuilder withItem(RuntimeQueryResultItem item) {
        this.item = item;
        return this;
    }

    public RuntimeListItem build() {
        RuntimeListItem result;
        PipelineExecutionTrace pipelineTrace;
        String runtimeName = this.item.getRuntimeName() != null ? this.item.getRuntimeName() : this.item.getRuntimeId();
        if (this.item.getPipelineExecutionId() != null) {
            Pipeline pipeline = new Pipeline(new PipelineKey(this.item.getPipelineId()));
            pipelineTrace = new PipelineExecutionTrace(new PipelineExecutionTraceKey(this.item.getPipelineExecutionId()));
            pipelineTrace.setPipelineStatus(this.transformToPipelineStatus(this.item.getPipelineStatus()));
            pipelineTrace.setPipelineError(new PipelineError(this.item.getPipelineError(), this.item.getPipelineErrorDetail()));
            this.item.getPipelineStageItems().getItems().forEach(stage -> {
                pipeline.addStage(new Stage((PipelineKey)pipeline.getKey(), stage.getName()));
                pipelineTrace.setStageStatus(stage.getName(), this.transformToPipelineStatus(stage.getStatus()));
                pipelineTrace.setStageError(stage.getName(), new PipelineError(stage.getStageError(), stage.getStageErrorDetail()));
            });
            pipelineTrace.setPipeline(pipeline);
        } else {
            pipelineTrace = null;
        }
        if (this.item.getRuntimeId() != null) {
            Runtime runtime = new Runtime(new RuntimeKey(new ProviderKey(new ProviderTypeKey(this.item.getProviderTypeName(), this.item.getProviderVersion()), this.item.getProviderId()), this.item.getRuntimeId()), this.item.getRuntimeStatus(), this.item.getRuntimeEndpoint(), this.item.getStartedAt());
            runtime.setPipelineTrace(pipelineTrace);
            result = new RuntimeListItem(runtimeName, runtime);
        } else {
            result = new RuntimeListItem(runtimeName, pipelineTrace);
        }
        return result;
    }

    private PipelineStatus transformToPipelineStatus(String status) {
        if (status == null) {
            return null;
        }
        switch (status) {
            case "SCHEDULED": {
                return PipelineStatus.SCHEDULED;
            }
            case "RUNNING": {
                return PipelineStatus.RUNNING;
            }
            case "FINISHED": {
                return PipelineStatus.FINISHED;
            }
            case "ERROR": {
                return PipelineStatus.ERROR;
            }
            case "STOPPED": {
                return PipelineStatus.STOPPED;
            }
        }
        return null;
    }
}

