/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.properties.editor.model;

import java.util.ArrayList;
import java.util.List;
import org.jboss.errai.common.client.api.annotations.Portable;
import org.kie.soup.commons.validation.PortablePreconditions;
import org.uberfire.ext.properties.editor.model.PropertyEditorFieldInfo;

@Portable
public class PropertyEditorCategory {
    private String name;
    private int priority = Integer.MAX_VALUE;
    private List<PropertyEditorFieldInfo> fields = new ArrayList<PropertyEditorFieldInfo>();
    private String idEvent;

    public PropertyEditorCategory() {
    }

    public PropertyEditorCategory(String name) {
        this.name = (String)PortablePreconditions.checkNotNull((String)"name", (Object)name);
    }

    public PropertyEditorCategory(String name, int priority) {
        this.name = (String)PortablePreconditions.checkNotNull((String)"name", (Object)name);
        this.priority = (Integer)PortablePreconditions.checkNotNull((String)"name", (Object)priority);
    }

    public PropertyEditorCategory withField(PropertyEditorFieldInfo field) {
        PortablePreconditions.checkNotNull((String)"field", (Object)field);
        field.setPropertyEditorCategory(this);
        this.fields.add(field);
        return this;
    }

    public String getName() {
        return this.name;
    }

    public int getPriority() {
        return this.priority;
    }

    public List<PropertyEditorFieldInfo> getFields() {
        return this.fields;
    }

    public int hashCode() {
        int result = this.name != null ? this.name.hashCode() : 0;
        result = 31 * result + this.priority;
        result = 31 * result + (this.fields != null ? this.fields.hashCode() : 0);
        return result;
    }

    public String getIdEvent() {
        return this.idEvent;
    }

    public void setIdEvent(String idEvent) {
        this.idEvent = idEvent;
    }

    public void undo() {
        this.fields.forEach(field -> field.undo());
    }

    public String toString() {
        return "PropertyEditorCategory{name=" + this.name + ", priority=" + this.priority + ", fields=" + this.fields + ", idEvent=" + this.idEvent + '}';
    }
}

