/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.messageconsole.utils;

import java.util.List;
import java.util.stream.Collectors;
import org.jboss.errai.common.client.api.annotations.Portable;

@Portable
public class CSVConverter {
    public static String convertTable(List<List<String>> table) {
        if (table == null) {
            return "";
        }
        return table.stream().map(CSVConverter::convertRow).collect(Collectors.joining("\n")).toString();
    }

    private static String convertRow(List<String> row) {
        return row.stream().map(CSVConverter::convertValue).collect(Collectors.joining(","));
    }

    private static String convertValue(String value) {
        return CSVConverter.quote(CSVConverter.escape(value));
    }

    private static String escape(String value) {
        return value.replaceAll("\n", "").replaceAll("\"", "\"\"");
    }

    private static String quote(String value) {
        return "\"" + value + "\"";
    }
}

