/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.forms.jbpm.server.service.impl.documents;

import java.util.Comparator;
import java.util.Set;
import java.util.TreeSet;
import org.kie.workbench.common.forms.jbpm.service.shared.documents.DocumentUploadChunk;

public class DocumentUploadSession {
    private String documentId;
    private String documentName;
    private int maxChunks;
    private Set<DocumentUploadChunk> chunks = new TreeSet<DocumentUploadChunk>(Comparator.comparing(DocumentUploadChunk::getIndex));
    private State state = State.UPLOADING;

    public DocumentUploadSession(String documentId, String documentName, int maxChunks) {
        this.documentId = documentId;
        this.documentName = documentName;
        this.maxChunks = maxChunks;
    }

    public String getDocumentId() {
        return this.documentId;
    }

    public String getDocumentName() {
        return this.documentName;
    }

    public Set<DocumentUploadChunk> getChunks() {
        return this.chunks;
    }

    public void add(DocumentUploadChunk chunk) {
        this.chunks.add(chunk);
    }

    public boolean isComplete() {
        return this.chunks.size() == this.maxChunks;
    }

    public State getState() {
        return this.state;
    }

    public void setState(State state) {
        this.state = state;
    }

    public static enum State {
        UPLOADING,
        MERGING,
        MERGED,
        ABORTED;

    }
}

