/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.utils;

import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class ActiveMQThreadPoolExecutor
extends ThreadPoolExecutor {
    private int maxPoolSize;

    public ActiveMQThreadPoolExecutor(int coreSize, int maxSize, long keep, TimeUnit keepUnits, ThreadFactory factory) {
        this(coreSize, maxSize, keep, keepUnits, new ThreadPoolQueue(), factory);
    }

    private ActiveMQThreadPoolExecutor(int coreSize, int maxSize, long keep, TimeUnit keepUnits, ThreadPoolQueue myQueue, ThreadFactory factory) {
        super(coreSize, Integer.MAX_VALUE, keep, keepUnits, (BlockingQueue<Runnable>)myQueue, factory);
        this.maxPoolSize = maxSize;
        myQueue.setExecutor(this);
    }

    @Override
    public int getMaximumPoolSize() {
        return this.maxPoolSize;
    }

    @Override
    public void setMaximumPoolSize(int maxSize) {
        this.maxPoolSize = maxSize;
    }

    private static class ThreadPoolQueue
    extends LinkedBlockingQueue<Runnable> {
        private ActiveMQThreadPoolExecutor executor = null;
        private final Object lock = new Object();
        private int threadTaskDelta = 0;

        private ThreadPoolQueue() {
        }

        public void setExecutor(ActiveMQThreadPoolExecutor executor) {
            this.executor = executor;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean offer(Runnable runnable) {
            boolean retval = false;
            Object object = this.lock;
            synchronized (object) {
                if ((this.executor.getPoolSize() >= this.executor.getMaximumPoolSize() || this.threadTaskDelta > 0) && (retval = super.offer(runnable))) {
                    --this.threadTaskDelta;
                }
            }
            return retval;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Runnable take() throws InterruptedException {
            Object object = this.lock;
            synchronized (object) {
                ++this.threadTaskDelta;
            }
            Runnable runnable = null;
            try {
                Runnable runnable2 = runnable = (Runnable)super.take();
                return runnable2;
            }
            finally {
                if (runnable == null) {
                    Object object2 = this.lock;
                    synchronized (object2) {
                        --this.threadTaskDelta;
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Runnable poll(long arg0, TimeUnit arg2) throws InterruptedException {
            Object object = this.lock;
            synchronized (object) {
                ++this.threadTaskDelta;
            }
            Runnable runnable = null;
            boolean timedOut = false;
            try {
                runnable = (Runnable)super.poll(arg0, arg2);
                timedOut = runnable == null;
            }
            finally {
                if (runnable == null) {
                    Object object2 = this.lock;
                    synchronized (object2) {
                        if (timedOut) {
                            runnable = (Runnable)super.poll();
                        }
                        if (runnable == null) {
                            --this.threadTaskDelta;
                        }
                    }
                }
            }
            return runnable;
        }
    }
}

