/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.indices.analyze;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.elasticsearch.Version;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.action.admin.indices.analyze.DetailAnalyzeResponse;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Streamable;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.ToXContentObject;
import org.elasticsearch.common.xcontent.XContentBuilder;

public class AnalyzeResponse
extends ActionResponse
implements Iterable<AnalyzeToken>,
ToXContentObject {
    private DetailAnalyzeResponse detail;
    private List<AnalyzeToken> tokens;

    AnalyzeResponse() {
    }

    public AnalyzeResponse(List<AnalyzeToken> tokens, DetailAnalyzeResponse detail) {
        this.tokens = tokens;
        this.detail = detail;
    }

    public List<AnalyzeToken> getTokens() {
        return this.tokens;
    }

    public DetailAnalyzeResponse detail() {
        return this.detail;
    }

    @Override
    public Iterator<AnalyzeToken> iterator() {
        return this.tokens.iterator();
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        if (this.tokens != null) {
            builder.startArray("tokens");
            for (AnalyzeToken token : this.tokens) {
                token.toXContent(builder, params);
            }
            builder.endArray();
        }
        if (this.detail != null) {
            builder.startObject("detail");
            this.detail.toXContent(builder, params);
            builder.endObject();
        }
        builder.endObject();
        return builder;
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        super.readFrom(in);
        int size = in.readVInt();
        this.tokens = new ArrayList<AnalyzeToken>(size);
        for (int i = 0; i < size; ++i) {
            this.tokens.add(AnalyzeToken.readAnalyzeToken(in));
        }
        if (in.getVersion().onOrAfter(Version.V_2_2_0)) {
            this.detail = in.readOptionalStreamable(DetailAnalyzeResponse::new);
        }
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        if (this.tokens != null) {
            out.writeVInt(this.tokens.size());
            for (AnalyzeToken token : this.tokens) {
                token.writeTo(out);
            }
        } else {
            out.writeVInt(0);
        }
        if (out.getVersion().onOrAfter(Version.V_2_2_0)) {
            out.writeOptionalStreamable(this.detail);
        }
    }

    static final class Fields {
        static final String TOKENS = "tokens";
        static final String TOKEN = "token";
        static final String START_OFFSET = "start_offset";
        static final String END_OFFSET = "end_offset";
        static final String TYPE = "type";
        static final String POSITION = "position";
        static final String POSITION_LENGTH = "positionLength";
        static final String DETAIL = "detail";

        Fields() {
        }
    }

    public static class AnalyzeToken
    implements Streamable,
    ToXContentObject {
        private String term;
        private int startOffset;
        private int endOffset;
        private int position;
        private int positionLength = 1;
        private Map<String, Object> attributes;
        private String type;

        AnalyzeToken() {
        }

        public AnalyzeToken(String term, int position, int startOffset, int endOffset, int positionLength, String type, Map<String, Object> attributes) {
            this.term = term;
            this.position = position;
            this.startOffset = startOffset;
            this.endOffset = endOffset;
            this.positionLength = positionLength;
            this.type = type;
            this.attributes = attributes;
        }

        public String getTerm() {
            return this.term;
        }

        public int getStartOffset() {
            return this.startOffset;
        }

        public int getEndOffset() {
            return this.endOffset;
        }

        public int getPosition() {
            return this.position;
        }

        public int getPositionLength() {
            return this.positionLength;
        }

        public String getType() {
            return this.type;
        }

        public Map<String, Object> getAttributes() {
            return this.attributes;
        }

        @Override
        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            builder.field("token", this.term);
            builder.field("start_offset", this.startOffset);
            builder.field("end_offset", this.endOffset);
            builder.field("type", this.type);
            builder.field("position", this.position);
            if (this.positionLength > 1) {
                builder.field("positionLength", this.positionLength);
            }
            if (this.attributes != null && !this.attributes.isEmpty()) {
                for (Map.Entry<String, Object> entity : this.attributes.entrySet()) {
                    builder.field(entity.getKey(), entity.getValue());
                }
            }
            builder.endObject();
            return builder;
        }

        public static AnalyzeToken readAnalyzeToken(StreamInput in) throws IOException {
            AnalyzeToken analyzeToken = new AnalyzeToken();
            analyzeToken.readFrom(in);
            return analyzeToken;
        }

        @Override
        public void readFrom(StreamInput in) throws IOException {
            this.term = in.readString();
            this.startOffset = in.readInt();
            this.endOffset = in.readInt();
            this.position = in.readVInt();
            if (in.getVersion().onOrAfter(Version.V_5_2_0)) {
                Integer len = in.readOptionalVInt();
                this.positionLength = len != null ? len : 1;
            }
            this.type = in.readOptionalString();
            if (in.getVersion().onOrAfter(Version.V_2_2_0)) {
                this.attributes = (Map)in.readGenericValue();
            }
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeString(this.term);
            out.writeInt(this.startOffset);
            out.writeInt(this.endOffset);
            out.writeVInt(this.position);
            if (out.getVersion().onOrAfter(Version.V_5_2_0)) {
                out.writeOptionalVInt(this.positionLength > 1 ? Integer.valueOf(this.positionLength) : null);
            }
            out.writeOptionalString(this.type);
            if (out.getVersion().onOrAfter(Version.V_2_2_0)) {
                out.writeGenericValue(this.attributes);
            }
        }
    }
}

