/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.process.workitem.ethereum;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import org.apache.commons.io.IOUtils;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.process.WorkItem;
import org.kie.api.runtime.process.WorkItemManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.web3j.abi.EventEncoder;
import org.web3j.abi.FunctionEncoder;
import org.web3j.abi.FunctionReturnDecoder;
import org.web3j.abi.TypeReference;
import org.web3j.abi.datatypes.Event;
import org.web3j.abi.datatypes.Function;
import org.web3j.abi.datatypes.Type;
import org.web3j.abi.datatypes.generated.AbiTypes;
import org.web3j.crypto.Credentials;
import org.web3j.crypto.RawTransaction;
import org.web3j.crypto.TransactionEncoder;
import org.web3j.protocol.Web3j;
import org.web3j.protocol.core.DefaultBlockParameter;
import org.web3j.protocol.core.DefaultBlockParameterName;
import org.web3j.protocol.core.methods.request.EthFilter;
import org.web3j.protocol.core.methods.request.Transaction;
import org.web3j.protocol.core.methods.response.EthCall;
import org.web3j.protocol.core.methods.response.EthGetBalance;
import org.web3j.protocol.core.methods.response.EthGetTransactionCount;
import org.web3j.protocol.core.methods.response.EthGetTransactionReceipt;
import org.web3j.protocol.core.methods.response.EthSendTransaction;
import org.web3j.protocol.core.methods.response.TransactionReceipt;
import org.web3j.tx.Transfer;
import org.web3j.utils.Convert;
import org.web3j.utils.Numeric;
import rx.functions.Action1;

public class EthereumUtils {
    public static final BigInteger DEFAULT_GAS_PRICE = BigInteger.valueOf(20000000000L);
    public static final BigInteger DEFAULT_GAS_LIMIT = BigInteger.valueOf(500000L);
    public static final int DEFAULT_SLEEP_DURATION = 15000;
    public static final int DEFAULT_ATTEMPTS = 40;
    public static final String TMP_FILE_PREFIX = "tmpfile";
    public static final String TMP_FILE_SUFFIX = ".tmp";
    private static final Logger logger = LoggerFactory.getLogger(EthereumUtils.class);

    public static Function getFunction(String queryName, List<Type> queryInputTypes, List<TypeReference<?>> queryOutputTypes) {
        List<Type> inputParameters = queryInputTypes != null ? queryInputTypes : new ArrayList<Type>();
        List<TypeReference<?>> outputTypes = queryOutputTypes != null ? queryOutputTypes : new ArrayList();
        Function function = new Function(queryName, inputParameters, outputTypes);
        return function;
    }

    public static String getEncodedFunction(String queryName, List<Type> queryInputTypes, List<TypeReference<?>> queryOutputTypes) {
        return FunctionEncoder.encode((Function)EthereumUtils.getFunction(queryName, queryInputTypes, queryOutputTypes));
    }

    public static String getEncodedFunction(Function function) {
        return FunctionEncoder.encode((Function)function);
    }

    public static BigInteger getNextNonce(String address, Web3j web3j) throws Exception {
        EthGetTransactionCount ethGetTransactionCount = (EthGetTransactionCount)web3j.ethGetTransactionCount(address, (DefaultBlockParameter)DefaultBlockParameterName.LATEST).sendAsync().get();
        return ethGetTransactionCount.getTransactionCount();
    }

    public static BigDecimal getBalanceInEther(Credentials credentials, Web3j web3j) throws Exception {
        EthGetBalance ethGetBalance = (EthGetBalance)web3j.ethGetBalance(credentials.getAddress(), (DefaultBlockParameter)DefaultBlockParameterName.LATEST).send();
        return Convert.fromWei((String)ethGetBalance.getBalance().toString(), (Convert.Unit)Convert.Unit.ETHER);
    }

    public static String deployContract(Credentials credentials, Web3j web3j, String contractBinary, int toSendEther, boolean waitForReceipt, int sleepDuration, int attempts) throws Exception {
        TransactionReceipt transReceipt;
        BigInteger depositEtherAmountToSend = BigInteger.valueOf(toSendEther);
        RawTransaction rawTransaction = RawTransaction.createContractTransaction((BigInteger)EthereumUtils.getNextNonce(credentials.getAddress(), web3j), (BigInteger)DEFAULT_GAS_PRICE, (BigInteger)DEFAULT_GAS_LIMIT, (BigInteger)depositEtherAmountToSend, (String)contractBinary);
        byte[] signedMessage = TransactionEncoder.signMessage((RawTransaction)rawTransaction, (Credentials)credentials);
        String hexValue = Numeric.toHexString((byte[])signedMessage);
        EthSendTransaction ethSendTransaction = (EthSendTransaction)web3j.ethSendRawTransaction(hexValue).sendAsync().get();
        if (waitForReceipt && (transReceipt = EthereumUtils.waitForTransactionReceipt(ethSendTransaction.getTransactionHash(), sleepDuration, attempts, web3j)) != null) {
            return transReceipt.getContractAddress();
        }
        logger.warn("Unable to retrieve contract address.");
        return null;
    }

    public static Object queryExistingContract(Credentials credentials, Web3j web3j, String contractAddress, String contractMethodName, List<Type> contractMethodInputTypes, List<TypeReference<?>> contractMethodOutputTypes) throws Exception {
        Function function = EthereumUtils.getFunction(contractMethodName, contractMethodInputTypes, contractMethodOutputTypes);
        Transaction transaction = Transaction.createEthCallTransaction((String)credentials.getAddress(), (String)contractAddress, (String)EthereumUtils.getEncodedFunction(function));
        EthCall response = (EthCall)web3j.ethCall(transaction, (DefaultBlockParameter)DefaultBlockParameterName.LATEST).sendAsync().get();
        List responseTypeList = FunctionReturnDecoder.decode((String)response.getValue(), (List)function.getOutputParameters());
        if (responseTypeList != null && responseTypeList.size() > 0) {
            return ((Type)responseTypeList.get(0)).getValue();
        }
        return null;
    }

    public static TransactionReceipt transactExistingContract(Credentials credentials, Web3j web3j, int etherAmount, BigInteger gasPrice, BigInteger gasLimit, String toAddress, String methodName, List<Type> methodInputTypes, List<TypeReference<?>> methodOutputTypes, boolean waitForReceipt, int sleepDuration, int attempts) throws Exception {
        BigInteger etherAmountToSend = BigInteger.valueOf(etherAmount);
        Transaction transaction = Transaction.createFunctionCallTransaction((String)credentials.getAddress(), (BigInteger)EthereumUtils.getNextNonce(credentials.getAddress(), web3j), (BigInteger)gasPrice, (BigInteger)gasLimit, (String)toAddress, (BigInteger)etherAmountToSend, (String)EthereumUtils.getEncodedFunction(methodName, methodInputTypes, methodOutputTypes));
        EthSendTransaction transactionResponse = (EthSendTransaction)web3j.ethSendTransaction(transaction).sendAsync().get();
        if (waitForReceipt) {
            TransactionReceipt transReceipt = EthereumUtils.waitForTransactionReceipt(transactionResponse.getTransactionHash(), sleepDuration, attempts, web3j);
            return transReceipt;
        }
        logger.warn("Unable to retrieve transaction receipt.");
        return null;
    }

    public static TransactionReceipt sendFundsToContract(Credentials credentials, Web3j web3j, int etherAmount, String toAddress, Transfer transfer) throws Exception {
        return (TransactionReceipt)transfer.sendFunds(toAddress, new BigDecimal(etherAmount), Convert.Unit.ETHER).send();
    }

    public static TransactionReceipt waitForTransactionReceipt(String transactionHash, int sleepDuration, int attempts, Web3j web3j) throws Exception {
        Optional<TransactionReceipt> transactionReceiptOptional = EthereumUtils.getTransactionReceipt(transactionHash, sleepDuration, attempts, web3j);
        if (!transactionReceiptOptional.isPresent()) {
            logger.warn("Transaction receipt not generated after " + attempts + " attempts.");
        }
        return transactionReceiptOptional.get();
    }

    public static Optional<TransactionReceipt> getTransactionReceipt(String transactionHash, int sleepDuration, int attempts, Web3j web3j) throws Exception {
        Optional<TransactionReceipt> receiptOptional = EthereumUtils.sendTransactionReceiptRequest(transactionHash, web3j);
        for (int i = 0; i < attempts && !receiptOptional.isPresent(); ++i) {
            Thread.sleep(sleepDuration);
            receiptOptional = EthereumUtils.sendTransactionReceiptRequest(transactionHash, web3j);
        }
        return receiptOptional;
    }

    public static Optional<TransactionReceipt> sendTransactionReceiptRequest(String transactionHash, Web3j web3j) throws Exception {
        EthGetTransactionReceipt transactionReceipt = (EthGetTransactionReceipt)web3j.ethGetTransactionReceipt(transactionHash).sendAsync().get();
        return transactionReceipt.getTransactionReceipt();
    }

    public static void observeContractEvent(Web3j web3j, String contractEventName, String contractAddress, List<TypeReference<?>> indexedParameters, List<TypeReference<?>> nonIndexedParameters, String eventReturnType, KieSession kieSession, String signalName, boolean doAbortOnUpdate, WorkItemManager workItemManager, WorkItem workItem) {
        Event event = new Event(contractEventName, indexedParameters, nonIndexedParameters);
        EthFilter filter = new EthFilter((DefaultBlockParameter)DefaultBlockParameterName.EARLIEST, (DefaultBlockParameter)DefaultBlockParameterName.LATEST, contractAddress);
        filter.addSingleTopic(EventEncoder.encode((Event)event));
        Class type = AbiTypes.getType((String)eventReturnType);
        TypeReference typeRef = TypeReference.create((Class)type);
        web3j.ethLogObservable(filter).subscribe(eventTrigger -> {
            kieSession.signalEvent(signalName, ((Type)FunctionReturnDecoder.decode((String)eventTrigger.getData(), Arrays.asList(typeRef)).get(0)).getValue());
            if (doAbortOnUpdate) {
                workItemManager.completeWorkItem(workItem.getId(), null);
            }
        });
    }

    public static void observeContractEvent(Web3j web3j, String contractEventName, String contractAddress, List<TypeReference<?>> indexedParameters, List<TypeReference<?>> nonIndexedParameters, String eventReturnType, Action1 action1) {
        Event event = new Event(contractEventName, indexedParameters, nonIndexedParameters);
        EthFilter filter = new EthFilter((DefaultBlockParameter)DefaultBlockParameterName.EARLIEST, (DefaultBlockParameter)DefaultBlockParameterName.LATEST, contractAddress);
        filter.addSingleTopic(EventEncoder.encode((Event)event));
        Class type = AbiTypes.getType((String)eventReturnType);
        TypeReference typeRef = TypeReference.create((Class)type);
        web3j.ethLogObservable(filter).subscribe(action1);
    }

    public static File createTmpFile(InputStream in) throws IOException {
        return EthereumUtils.createTmpFile(in, TMP_FILE_PREFIX, TMP_FILE_SUFFIX);
    }

    public static File createTmpFile(InputStream in, String filePrefix, String fileSuffix) throws IOException {
        File tempFile = File.createTempFile(filePrefix, fileSuffix);
        tempFile.deleteOnExit();
        try (FileOutputStream out = new FileOutputStream(tempFile);){
            IOUtils.copy((InputStream)in, (OutputStream)out);
        }
        return tempFile;
    }

    public static String convertStreamToStr(InputStream inputStream) throws IOException {
        return IOUtils.toString((InputStream)inputStream, (Charset)StandardCharsets.UTF_8);
    }
}

