/*
 * Decompiled with CFR 0.152.
 */
package com.kie.workbench.common.stunner.cm.service;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.LinkedList;
import java.util.Optional;
import javax.annotation.PostConstruct;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.Instance;
import javax.inject.Inject;
import org.jboss.errai.bus.server.annotations.Service;
import org.kie.workbench.common.stunner.cm.project.service.CaseManagementSwitchViewService;
import org.kie.workbench.common.stunner.core.api.FactoryManager;
import org.kie.workbench.common.stunner.core.definition.service.DefinitionSetService;
import org.kie.workbench.common.stunner.core.diagram.AbstractMetadata;
import org.kie.workbench.common.stunner.core.diagram.Diagram;
import org.kie.workbench.common.stunner.core.diagram.Metadata;
import org.kie.workbench.common.stunner.core.factory.diagram.DiagramFactory;
import org.kie.workbench.common.stunner.core.graph.Graph;
import org.kie.workbench.common.stunner.core.graph.content.definition.DefinitionSet;
import org.kie.workbench.common.stunner.project.diagram.ProjectDiagram;
import org.kie.workbench.common.stunner.project.diagram.ProjectMetadata;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApplicationScoped
@Service
public class CaseManagementSwitchViewServiceImpl
implements CaseManagementSwitchViewService {
    private static final Logger LOGGER = LoggerFactory.getLogger(CaseManagementSwitchViewServiceImpl.class);
    private final FactoryManager factoryManager;
    private final Instance<DefinitionSetService> definitionSetServiceInstances;
    Collection<DefinitionSetService> definitionSetServices;

    @Inject
    public CaseManagementSwitchViewServiceImpl(FactoryManager factoryManager, Instance<DefinitionSetService> definitionSetServiceInstances) {
        this.factoryManager = factoryManager;
        this.definitionSetServiceInstances = definitionSetServiceInstances;
        this.definitionSetServices = new LinkedList<DefinitionSetService>();
    }

    @PostConstruct
    public void init() {
        this.definitionSetServiceInstances.forEach(i -> this.definitionSetServices.add((DefinitionSetService)i));
    }

    public Optional<ProjectDiagram> switchView(Diagram diagram, String mappedDefSetId, String mappedShapeSetId) {
        Metadata metadata = diagram.getMetadata();
        String defSetId = metadata.getDefinitionSetId();
        Optional<DefinitionSetService> definitionSetServiceOptional = this.definitionSetServices.stream().filter(s -> s.accepts(defSetId)).findAny();
        return definitionSetServiceOptional.map(service -> {
            try {
                String rawData = service.getDiagramMarshaller().marshall(diagram);
                Optional<DefinitionSetService> mappedDefinitionSetServiceOptional = this.definitionSetServices.stream().filter(s -> s.accepts(mappedDefSetId)).findAny();
                return mappedDefinitionSetServiceOptional.map(mappedService -> {
                    ((AbstractMetadata)metadata).setDefinitionSetId(mappedDefSetId);
                    try (ByteArrayInputStream inputStream = new ByteArrayInputStream(rawData.getBytes());){
                        Graph graph = mappedService.getDiagramMarshaller().unmarshall(metadata, (InputStream)inputStream);
                        DiagramFactory factory = this.factoryManager.registry().getDiagramFactory((String)((DefinitionSet)graph.getContent()).getDefinition(), metadata.getMetadataType());
                        ProjectDiagram mappedDiagram = (ProjectDiagram)factory.build(metadata.getTitle(), metadata, graph);
                        ((ProjectMetadata)mappedDiagram.getMetadata()).setShapeSetId(mappedShapeSetId);
                        ProjectDiagram projectDiagram = mappedDiagram;
                        return projectDiagram;
                    }
                    catch (IOException e) {
                        return this.handleError(Optional.of(e));
                    }
                }).orElseGet(() -> this.handleError(Optional.empty()));
            }
            catch (IOException e) {
                return this.handleError(Optional.of(e));
            }
        });
    }

    private ProjectDiagram handleError(Optional<Exception> e) {
        if (e.isPresent()) {
            LOGGER.error("Error converting diagram.", (Throwable)e.get());
        } else {
            LOGGER.error("Error converting diagram.");
        }
        return null;
    }
}

