/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.core.util;

import java.util.Comparator;
import java.util.function.Supplier;

public class SafeComparator<T>
implements Comparator<T> {
    public static final SafeComparator<Object> TO_STRING_COMPARATOR = SafeComparator.of(() -> (obj1, obj2) -> obj1.toString().compareTo(obj2.toString()));
    public static final SafeComparator<Object> TO_STRING_REVERSE_COMPARATOR = SafeComparator.of(() -> (obj1, obj2) -> obj2.toString().compareTo(obj1.toString()));
    private Supplier<Comparator<T>> comparatorSupplier;

    private SafeComparator(Supplier<Comparator<T>> comparatorSupplier) {
        this.comparatorSupplier = comparatorSupplier;
    }

    public static <K> SafeComparator<K> of(Supplier<Comparator<K>> comparatorSupplier) {
        return new SafeComparator(comparatorSupplier);
    }

    @Override
    public int compare(T obj1, T obj2) {
        if (obj1 == null) {
            return obj2 != null ? -1 : 0;
        }
        if (obj2 == null) {
            return 1;
        }
        return this.comparatorSupplier.get().compare(obj1, obj2);
    }
}

