/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.bpmn.backend.converters.customproperties.elements;

import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.bpmn2.BaseElement;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.impl.EStructuralFeatureImpl;
import org.eclipse.emf.ecore.util.FeatureMap;
import org.jboss.drools.DroolsFactory;
import org.jboss.drools.DroolsPackage;
import org.jboss.drools.GlobalType;
import org.kie.workbench.common.stunner.bpmn.backend.converters.customproperties.elements.ElementDefinition;

public class GlobalVariablesElement
extends ElementDefinition<String> {
    public GlobalVariablesElement(String name) {
        super(name, "");
    }

    @Override
    public String getValue(BaseElement element) {
        return this.getStringValue(element).orElse((String)this.getDefaultValue());
    }

    @Override
    public void setValue(BaseElement element, String value) {
        this.setStringValue(element, value);
    }

    private Optional<String> getStringValue(BaseElement element) {
        List extValues = element.getExtensionValues();
        List extElementsList = extValues.stream().map(extAttrVal -> extAttrVal.getValue()).collect(Collectors.toList());
        List globalExtensions = extElementsList.stream().map(extAttrVal -> (List)extAttrVal.get((EStructuralFeature)DroolsPackage.Literals.DOCUMENT_ROOT__GLOBAL, true)).flatMap(Collection::stream).collect(Collectors.toList());
        String globalVariables = globalExtensions.stream().map(globalType -> globalType.getIdentifier() + ":" + globalType.getType()).collect(Collectors.joining(","));
        return Optional.ofNullable(globalVariables);
    }

    private void setStringValue(BaseElement element, String value) {
        Stream.of(value.split(",")).map(GlobalVariablesElement::extensionOf).forEach(arg_0 -> GlobalVariablesElement.getExtensionElements(element).add(arg_0));
    }

    static FeatureMap.Entry extensionOf(String variable) {
        return new EStructuralFeatureImpl.SimpleFeatureMapEntry((EStructuralFeature.Internal)DroolsPackage.Literals.DOCUMENT_ROOT__GLOBAL, (Object)GlobalVariablesElement.globalTypeDataOf(variable));
    }

    static GlobalType globalTypeDataOf(String variable) {
        GlobalType globalType = DroolsFactory.eINSTANCE.createGlobalType();
        String[] properties = variable.split(":", -1);
        globalType.setIdentifier(properties[0]);
        globalType.setType(properties[1]);
        return globalType;
    }
}

