/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.bpmn.backend.converters.fromstunner.properties;

import java.util.Optional;
import java.util.Set;
import org.eclipse.bpmn2.DataObject;
import org.eclipse.bpmn2.DataObjectReference;
import org.eclipse.bpmn2.FlowElement;
import org.eclipse.bpmn2.ItemDefinition;
import org.kie.workbench.common.stunner.bpmn.backend.converters.fromstunner.Factories;
import org.kie.workbench.common.stunner.bpmn.backend.converters.fromstunner.properties.PropertyWriter;
import org.kie.workbench.common.stunner.bpmn.backend.converters.fromstunner.properties.VariableScope;
import org.kie.workbench.common.stunner.core.util.StringUtils;

public class DataObjectPropertyWriter
extends PropertyWriter {
    private final Set<DataObject> dataObjects;
    private final DataObject dataObject;

    public DataObjectPropertyWriter(DataObjectReference element, VariableScope variableScope, Set<DataObject> dataObjects) {
        super((FlowElement)element, variableScope);
        this.dataObjects = dataObjects;
        this.dataObject = Factories.bpmn2.createDataObject();
        element.setDataObjectRef(this.dataObject);
    }

    @Override
    public void setName(String value) {
        String escaped = StringUtils.replaceIllegalCharsAttribute((String)value.trim());
        this.dataObject.setName(escaped);
        this.dataObject.setId(escaped);
    }

    private void addDataObjectToProcess(DataObject dataObject) {
        Optional<DataObject> any = this.dataObjects.stream().filter(elm -> elm.getId().equals(dataObject.getId())).findAny();
        if (any.isPresent()) {
            if (!any.get().getItemSubjectRef().getStructureRef().equals(dataObject.getItemSubjectRef().getStructureRef())) {
                any.get().getItemSubjectRef().setStructureRef("Object");
            }
        } else {
            this.dataObjects.add(dataObject);
        }
    }

    public void setType(String type) {
        ItemDefinition itemDefinition = Factories.bpmn2.createItemDefinition();
        itemDefinition.setStructureRef(type);
        this.dataObject.setItemSubjectRef(itemDefinition);
        this.addDataObjectToProcess(this.dataObject);
    }

    public DataObjectReference getElement() {
        return (DataObjectReference)super.getElement();
    }

    public Set<DataObject> getDataObjects() {
        return this.dataObjects;
    }
}

