/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.bpmn.backend.converters.fromstunner.properties;

import java.util.Set;
import org.eclipse.bpmn2.Activity;
import org.eclipse.bpmn2.BaseElement;
import org.eclipse.bpmn2.DataObject;
import org.eclipse.bpmn2.FlowElement;
import org.eclipse.bpmn2.Interface;
import org.eclipse.bpmn2.ItemDefinition;
import org.eclipse.bpmn2.Message;
import org.eclipse.bpmn2.Operation;
import org.eclipse.bpmn2.RootElement;
import org.eclipse.bpmn2.ServiceTask;
import org.kie.workbench.common.stunner.bpmn.backend.converters.customproperties.CustomAttribute;
import org.kie.workbench.common.stunner.bpmn.backend.converters.customproperties.CustomElement;
import org.kie.workbench.common.stunner.bpmn.backend.converters.fromstunner.Factories;
import org.kie.workbench.common.stunner.bpmn.backend.converters.fromstunner.properties.MultipleInstanceActivityPropertyWriter;
import org.kie.workbench.common.stunner.bpmn.backend.converters.fromstunner.properties.VariableScope;
import org.kie.workbench.common.stunner.bpmn.backend.converters.tostunner.properties.GenericServiceTaskPropertyReader;
import org.kie.workbench.common.stunner.bpmn.backend.converters.tostunner.properties.Scripts;
import org.kie.workbench.common.stunner.bpmn.definition.property.service.GenericServiceTaskValue;
import org.kie.workbench.common.stunner.bpmn.definition.property.task.OnEntryAction;
import org.kie.workbench.common.stunner.bpmn.definition.property.task.OnExitAction;

public class GenericServiceTaskPropertyWriter
extends MultipleInstanceActivityPropertyWriter {
    private final ServiceTask task;
    private final Interface iface;

    public GenericServiceTaskPropertyWriter(ServiceTask task, VariableScope variableScope, Set<DataObject> dataObjects) {
        super((Activity)task, variableScope, dataObjects);
        this.task = task;
        this.iface = Factories.bpmn2.createInterface();
    }

    public void setValue(GenericServiceTaskValue value) {
        String serviceImplementation = value.getServiceImplementation();
        this.task.setImplementation(GenericServiceTaskPropertyReader.getServiceImplementation(serviceImplementation));
        CustomAttribute.serviceImplementation.of((BaseElement)this.task).set(serviceImplementation);
        String serviceInterface = value.getServiceInterface();
        ItemDefinition itemDefinitionInMsg = Factories.bpmn2.createItemDefinition();
        itemDefinitionInMsg.setId(this.task.getId() + "_InMessageType");
        itemDefinitionInMsg.setStructureRef(value.getInMessageStructure());
        this.addItemDefinition(itemDefinitionInMsg);
        Message inMessage = Factories.bpmn2.createMessage();
        inMessage.setId(this.task.getId() + "_InMessage");
        inMessage.setItemRef(itemDefinitionInMsg);
        this.addRootElement((RootElement)inMessage);
        ItemDefinition itemDefinitionOutMsg = Factories.bpmn2.createItemDefinition();
        itemDefinitionOutMsg.setId(this.task.getId() + "_OutMessageType");
        itemDefinitionOutMsg.setStructureRef(value.getOutMessagetructure());
        this.addItemDefinition(itemDefinitionOutMsg);
        Message outMessage = Factories.bpmn2.createMessage();
        outMessage.setId(this.task.getId() + "_OutMessage");
        outMessage.setItemRef(itemDefinitionOutMsg);
        this.addRootElement((RootElement)outMessage);
        CustomAttribute.serviceInterface.of((BaseElement)this.task).set(serviceInterface);
        this.iface.setImplementationRef(serviceInterface);
        this.iface.setName(serviceInterface);
        this.iface.setId(this.task.getId() + "_ServiceInterface");
        String serviceOperation = value.getServiceOperation();
        CustomAttribute.serviceOperation.of((BaseElement)this.task).set(serviceOperation);
        Operation operation = Factories.bpmn2.createOperation();
        operation.setId(this.task.getId() + "_ServiceOperation");
        operation.setName(serviceOperation);
        operation.setImplementationRef(serviceOperation);
        this.iface.getOperations().add(operation);
        this.task.setOperationRef(operation);
        this.addInterfaceDefinition(this.iface);
        operation.setInMessageRef(inMessage);
        operation.setOutMessageRef(outMessage);
    }

    public void setAdHocAutostart(boolean autoStart) {
        CustomElement.autoStart.of((BaseElement)this.task).set(autoStart);
    }

    public void setAsync(boolean async) {
        CustomElement.async.of((BaseElement)this.task).set(async);
    }

    public void setSLADueDate(String slaDueDate) {
        CustomElement.slaDueDate.of((BaseElement)this.task).set(slaDueDate);
    }

    public void setOnEntryAction(OnEntryAction onEntryAction) {
        Scripts.setOnEntryAction((FlowElement)this.task, onEntryAction);
    }

    public void setOnExitAction(OnExitAction onExitAction) {
        Scripts.setOnExitAction((FlowElement)this.task, onExitAction);
    }
}

