/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.bpmn.backend.converters.fromstunner.properties.util;

import java.util.List;
import java.util.Set;
import org.eclipse.bpmn2.DataObject;
import org.eclipse.bpmn2.FlowElement;
import org.eclipse.bpmn2.FlowElementsContainer;
import org.eclipse.bpmn2.ItemDefinition;
import org.kie.workbench.common.stunner.bpmn.backend.converters.fromstunner.Ids;

public class DataObjectUtils {
    private DataObjectUtils() {
    }

    public static void maybeAddDataObjectToItemDefinitions(List<ItemDefinition> itemDefinitions, Set<DataObject> dataObjects) {
        dataObjects.forEach(elm -> DataObjectUtils.maybeAddDataObjectToItemDefinitions(itemDefinitions, elm));
    }

    public static void maybeAddDataObjectToItemDefinitions(List<ItemDefinition> itemDefinitions, DataObject data) {
        if (itemDefinitions.stream().noneMatch(elm -> elm.getId().equals(Ids.item(data.getId())))) {
            data.getItemSubjectRef().setId(Ids.item(data.getId()));
            itemDefinitions.add(data.getItemSubjectRef());
        }
    }

    public static void maybeAddDataObjects(FlowElementsContainer process, Set<DataObject> dataObjects) {
        dataObjects.stream().filter(elm -> !DataObjectUtils.checkIfDataObjectExists(process.getFlowElements(), elm)).forEach(elm -> process.getFlowElements().add(elm));
    }

    public static boolean checkIfDataObjectExists(List<FlowElement> flowElements, DataObject dataObject) {
        return flowElements.stream().filter(elm -> elm instanceof DataObject).anyMatch(elm -> elm.getId().equals(dataObject.getId()));
    }
}

