/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.bpmn.backend.converters.tostunner.properties;

import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.bpmn2.ConditionalEventDefinition;
import org.eclipse.bpmn2.Event;
import org.eclipse.bpmn2.EventDefinition;
import org.eclipse.bpmn2.Expression;
import org.eclipse.bpmn2.FlowElement;
import org.eclipse.bpmn2.FormalExpression;
import org.eclipse.bpmn2.LinkEventDefinition;
import org.eclipse.bpmn2.SignalEventDefinition;
import org.eclipse.bpmn2.TimerEventDefinition;
import org.eclipse.bpmn2.di.BPMNDiagram;
import org.eclipse.dd.dc.Bounds;
import org.kie.workbench.common.stunner.bpmn.backend.converters.customproperties.CustomElement;
import org.kie.workbench.common.stunner.bpmn.backend.converters.tostunner.DefinitionResolver;
import org.kie.workbench.common.stunner.bpmn.backend.converters.tostunner.properties.FlowElementPropertyReader;
import org.kie.workbench.common.stunner.bpmn.backend.converters.tostunner.properties.Scripts;
import org.kie.workbench.common.stunner.bpmn.backend.converters.tostunner.properties.SimulationAttributeSets;
import org.kie.workbench.common.stunner.bpmn.definition.property.common.ConditionExpression;
import org.kie.workbench.common.stunner.bpmn.definition.property.dataio.AssignmentsInfo;
import org.kie.workbench.common.stunner.bpmn.definition.property.event.timer.TimerSettingsValue;
import org.kie.workbench.common.stunner.bpmn.definition.property.simulation.SimulationAttributeSet;
import org.kie.workbench.common.stunner.bpmn.definition.property.task.ScriptTypeValue;
import org.kie.workbench.common.stunner.core.util.StringUtils;

public abstract class EventPropertyReader
extends FlowElementPropertyReader {
    static final double WIDTH = 56.0;
    static final double HEIGHT = 56.0;
    protected final DefinitionResolver definitionResolver;

    EventPropertyReader(Event element, BPMNDiagram diagram, DefinitionResolver definitionResolver) {
        super((FlowElement)element, diagram, definitionResolver.getShape(element.getId()), definitionResolver.getResolutionFactor());
        this.definitionResolver = definitionResolver;
    }

    @Override
    protected org.kie.workbench.common.stunner.core.graph.content.Bounds computeBounds(Bounds bounds) {
        double x = (double)bounds.getX() * this.resolutionFactor;
        double y = (double)bounds.getY() * this.resolutionFactor;
        return org.kie.workbench.common.stunner.core.graph.content.Bounds.create((double)x, (double)y, (double)(x + 56.0), (double)(y + 56.0));
    }

    public String getSignalScope() {
        return (String)CustomElement.scope.of(this.element).get();
    }

    public abstract List<EventDefinition> getEventDefinitions();

    public abstract AssignmentsInfo getAssignmentsInfo();

    public static TimerSettingsValue getTimerSettings(TimerEventDefinition eventDefinition) {
        TimerSettingsValue timerSettingsValue = new TimerSettingsValue();
        EventPropertyReader.toFormalExpression(eventDefinition.getTimeCycle()).ifPresent(timeCycle -> {
            timerSettingsValue.setTimeCycle(timeCycle.getBody());
            timerSettingsValue.setTimeCycleLanguage(timeCycle.getLanguage());
        });
        EventPropertyReader.toFormalExpression(eventDefinition.getTimeDate()).ifPresent(timeDate -> timerSettingsValue.setTimeDate(timeDate.getBody()));
        EventPropertyReader.toFormalExpression(eventDefinition.getTimeDuration()).ifPresent(timeDateDuration -> timerSettingsValue.setTimeDuration(timeDateDuration.getBody()));
        return timerSettingsValue;
    }

    private static Optional<FormalExpression> toFormalExpression(Expression e) {
        if (e instanceof FormalExpression) {
            return Optional.of((FormalExpression)e);
        }
        return Optional.empty();
    }

    public String getSignalRef() {
        List<EventDefinition> eventDefinitions = this.getEventDefinitions();
        if (eventDefinitions.size() == 1 && eventDefinitions.get(0) instanceof SignalEventDefinition) {
            String signalRefId = ((SignalEventDefinition)eventDefinitions.get(0)).getSignalRef();
            return signalRefId != null ? this.definitionResolver.resolveSignalName(signalRefId) : "";
        }
        return "";
    }

    public String getLinkRef() {
        List<EventDefinition> eventDefinitions = this.getEventDefinitions();
        if (eventDefinitions.size() == 1 && eventDefinitions.get(0) instanceof LinkEventDefinition) {
            String linkRef = ((LinkEventDefinition)eventDefinitions.get(0)).getName();
            return linkRef != null ? StringUtils.revertIllegalCharsAttribute((String)linkRef) : "";
        }
        return "";
    }

    public SimulationAttributeSet getSimulationSet() {
        return this.definitionResolver.resolveSimulationParameters(this.element.getId()).map(SimulationAttributeSets::of).orElse(new SimulationAttributeSet());
    }

    public String getSlaDueDate() {
        return (String)CustomElement.slaDueDate.of(this.element).get();
    }

    public static ConditionExpression getConditionExpression(ConditionalEventDefinition conditionalEvent) {
        if (conditionalEvent.getCondition() instanceof FormalExpression) {
            FormalExpression formalExpression = (FormalExpression)conditionalEvent.getCondition();
            String language = Scripts.scriptLanguageFromUri(formalExpression.getLanguage(), Scripts.LANGUAGE.DROOLS.language());
            String script = formalExpression.getBody();
            return new ConditionExpression(new ScriptTypeValue(language, script));
        }
        return new ConditionExpression(new ScriptTypeValue(Scripts.LANGUAGE.DROOLS.language(), ""));
    }

    protected static List<EventDefinition> combineEventDefinitions(List<EventDefinition> eventDefinitions, List<EventDefinition> eventDefinitionRefs) {
        return Stream.concat(eventDefinitions.stream(), eventDefinitionRefs.stream().filter(Objects::nonNull).filter(eventDefinition -> Objects.nonNull(eventDefinition.getId()))).collect(Collectors.toList());
    }
}

