/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.bpmn.backend.converters.tostunner.properties;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.bpmn2.Assignment;
import org.eclipse.bpmn2.DataInput;
import org.eclipse.bpmn2.DataInputAssociation;
import org.eclipse.bpmn2.FormalExpression;
import org.kie.workbench.common.stunner.bpmn.backend.converters.customproperties.ParsedReassignmentsInfos;
import org.kie.workbench.common.stunner.bpmn.backend.converters.fromstunner.associations.AssociationType;
import org.kie.workbench.common.stunner.bpmn.definition.property.reassignment.ReassignmentTypeListValue;
import org.kie.workbench.common.stunner.bpmn.definition.property.reassignment.ReassignmentsInfo;

public class ReassignmentsInfos {
    private static Set<String> RESERVED_ASSIGNMENTS = new HashSet<String>(Arrays.asList(AssociationType.NOT_COMPLETED_REASSIGN.getName(), AssociationType.NOT_STARTED_REASSIGN.getName()));

    public static ReassignmentsInfo of(List<DataInputAssociation> dataInputAssociations) {
        ReassignmentTypeListValue reassignments = new ReassignmentTypeListValue();
        dataInputAssociations.forEach(din -> {
            String body;
            Assignment assignment;
            DataInput targetRef = (DataInput)din.getTargetRef();
            if (ReassignmentsInfos.isReservedIdentifier(targetRef.getName()) && !din.getAssignment().isEmpty() && (assignment = (Assignment)din.getAssignment().get(0)) != null && (body = ((FormalExpression)assignment.getFrom()).getBody()) != null) {
                Arrays.stream(ReassignmentsInfos.replaceBracket(body).split("\\^")).forEach(b -> reassignments.addValue(ParsedReassignmentsInfos.of(targetRef.getName(), b)));
            }
        });
        return new ReassignmentsInfo(reassignments);
    }

    public static boolean isReservedIdentifier(String targetName) {
        return RESERVED_ASSIGNMENTS.contains(targetName);
    }

    private static String replaceBracket(String original) {
        return original.replaceFirst("\\[", "").replace("]", "");
    }
}

