/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.bpmn.backend.converters.customproperties;

import java.util.Locale;
import org.eclipse.bpmn2.BaseElement;
import org.eclipse.bpmn2.BoundaryEvent;
import org.junit.Assert;
import org.junit.Test;
import org.kie.workbench.common.stunner.bpmn.backend.converters.customproperties.CustomAttribute;
import org.kie.workbench.common.stunner.bpmn.backend.converters.fromstunner.Factories;
import org.kie.workbench.common.stunner.core.graph.content.view.Point2D;

public class CustomAttributeTest {
    private static final double POINT2D_X_COORDINATE = 1.0;
    private static final double POINT2D_Y_COORDINATE = 2.0;

    @Test
    public void packageNameSetEmpty() {
        BaseElement baseElement = this.createBaseElement();
        CustomAttribute packageName = CustomAttribute.packageName.of(baseElement);
        packageName.set((Object)"");
        Assert.assertEquals((Object)"org.jbpm", (Object)packageName.get());
    }

    @Test
    public void packageNameSetNull() {
        BaseElement baseElement = this.createBaseElement();
        CustomAttribute packageName = CustomAttribute.packageName.of(baseElement);
        packageName.set(null);
        Assert.assertEquals(null, (Object)packageName.get());
    }

    @Test
    public void dockerInfoSet() {
        CustomAttribute<Point2D> dockerInfo = this.createDockerInfoAttribute();
        Point2D point2D = new Point2D(1.0, 2.0);
        dockerInfo.set((Object)point2D);
        Assert.assertEquals((Object)point2D, (Object)dockerInfo.get());
    }

    @Test
    public void dockerInfoSetLocalization() {
        Locale defaultLocale = Locale.getDefault();
        Locale.setDefault(new Locale("cs", "CZ"));
        CustomAttribute<Point2D> dockerInfo = this.createDockerInfoAttribute();
        Point2D point2D = new Point2D(1.0, 2.0);
        dockerInfo.set((Object)point2D);
        Assert.assertEquals((Object)point2D, (Object)dockerInfo.get());
        Locale.setDefault(defaultLocale);
    }

    private CustomAttribute<Point2D> createDockerInfoAttribute() {
        BoundaryEvent baseElement = Factories.bpmn2.createBoundaryEvent();
        return CustomAttribute.dockerInfo.of((BaseElement)baseElement);
    }

    private BaseElement createBaseElement() {
        return Factories.bpmn2.createTask();
    }
}

