/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.bpmn.backend.converters.tostunner.properties;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.bpmn2.Activity;
import org.eclipse.bpmn2.DataInput;
import org.eclipse.bpmn2.DataInputAssociation;
import org.eclipse.bpmn2.DataOutput;
import org.eclipse.bpmn2.DataOutputAssociation;
import org.eclipse.bpmn2.ExtensionAttributeValue;
import org.eclipse.bpmn2.InputOutputSpecification;
import org.eclipse.bpmn2.ItemAwareElement;
import org.eclipse.bpmn2.ItemDefinition;
import org.eclipse.bpmn2.Property;
import org.eclipse.bpmn2.di.BPMNDiagram;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.FeatureMap;
import org.jboss.drools.DroolsPackage;
import org.jboss.drools.OnEntryScriptType;
import org.jboss.drools.OnExitScriptType;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.stunner.bpmn.backend.converters.tostunner.DefinitionResolver;
import org.kie.workbench.common.stunner.bpmn.backend.converters.tostunner.properties.ActivityPropertyReader;
import org.kie.workbench.common.stunner.bpmn.definition.property.dataio.AssignmentsInfo;
import org.kie.workbench.common.stunner.bpmn.definition.property.task.ScriptTypeListValue;
import org.kie.workbench.common.stunner.bpmn.definition.property.task.ScriptTypeValue;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class ActivityPropertyReaderTest {
    private static final String JAVA = "java";
    private static final String JAVA_FORMAT = "http://www.java.com/java";
    private static final String SCRIPT = "SCRIPT";
    @Mock
    private Activity activity;
    @Mock
    private BPMNDiagram diagram;
    @Mock
    private DefinitionResolver definitionResolver;
    private ActivityPropertyReader reader;

    @Before
    public void setUp() {
        this.reader = new ActivityPropertyReader(this.activity, this.diagram, this.definitionResolver);
    }

    @Test
    public void testGetOnEntryScript() {
        OnEntryScriptType onEntryScript = (OnEntryScriptType)Mockito.mock(OnEntryScriptType.class);
        Mockito.when((Object)onEntryScript.getScript()).thenReturn((Object)SCRIPT);
        Mockito.when((Object)onEntryScript.getScriptFormat()).thenReturn((Object)JAVA_FORMAT);
        List<OnEntryScriptType> onEntryScripts = Collections.singletonList(onEntryScript);
        List<ExtensionAttributeValue> extensions = ActivityPropertyReaderTest.mockExtensions((EStructuralFeature)DroolsPackage.Literals.DOCUMENT_ROOT__ON_ENTRY_SCRIPT, onEntryScripts);
        Mockito.when((Object)this.activity.getExtensionValues()).thenReturn(extensions);
        ActivityPropertyReaderTest.assertScript(JAVA, SCRIPT, this.reader.getOnEntryAction());
    }

    @Test
    public void testGetOnExitScript() {
        OnExitScriptType onExitScript = (OnExitScriptType)Mockito.mock(OnExitScriptType.class);
        Mockito.when((Object)onExitScript.getScript()).thenReturn((Object)SCRIPT);
        Mockito.when((Object)onExitScript.getScriptFormat()).thenReturn((Object)JAVA_FORMAT);
        List<OnExitScriptType> onExitScripts = Collections.singletonList(onExitScript);
        List<ExtensionAttributeValue> extensions = ActivityPropertyReaderTest.mockExtensions((EStructuralFeature)DroolsPackage.Literals.DOCUMENT_ROOT__ON_EXIT_SCRIPT, onExitScripts);
        Mockito.when((Object)this.activity.getExtensionValues()).thenReturn(extensions);
        ActivityPropertyReaderTest.assertScript(JAVA, SCRIPT, this.reader.getOnExitAction());
    }

    @Test
    public void testGetAssignmentsInfo() {
        ArrayList<DataInput> dataInputs = new ArrayList<DataInput>();
        DataInput dataInput1 = ActivityPropertyReaderTest.mockDataInput("INPUT_ID_1", "INPUT_NAME_1", this.mockEntry("dtype", "Integer"));
        DataInput dataInput2 = ActivityPropertyReaderTest.mockDataInput("INPUT_ID_2", "INPUT_NAME_2", this.mockEntry("dtype", "String"));
        dataInputs.add(dataInput1);
        dataInputs.add(dataInput2);
        InputOutputSpecification ioSpec = (InputOutputSpecification)Mockito.mock(InputOutputSpecification.class);
        ArrayList<DataInputAssociation> dataInputAssociations = new ArrayList<DataInputAssociation>();
        DataInputAssociation inputAssociation = ActivityPropertyReaderTest.mockDataInputAssociation((ItemAwareElement)dataInput1, "VARIABLE1");
        DataInputAssociation inputAssociation2 = ActivityPropertyReaderTest.mockDataInputAssociation((ItemAwareElement)dataInput2, "VARIABLE2");
        dataInputAssociations.add(inputAssociation);
        dataInputAssociations.add(inputAssociation2);
        ArrayList<DataOutput> dataOutputs = new ArrayList<DataOutput>();
        DataOutput dataOutput1 = ActivityPropertyReaderTest.mockDataOutput("OUTPUT_ID_1", "OUTPUT_NAME_1", this.mockEntry("dtype", "Boolean"));
        DataOutput dataOutput2 = ActivityPropertyReaderTest.mockDataOutput("OUTPUT_ID_2", "OUTPUT_NAME_2", this.mockEntry("dtype", "Float"));
        dataOutputs.add(dataOutput1);
        dataOutputs.add(dataOutput2);
        ArrayList<DataOutputAssociation> dataOutputAssociations = new ArrayList<DataOutputAssociation>();
        DataOutputAssociation outputAssociation1 = ActivityPropertyReaderTest.mockDataOutputAssociation((ItemAwareElement)dataOutput1, "VARIABLE3");
        DataOutputAssociation outputAssociation2 = ActivityPropertyReaderTest.mockDataOutputAssociation((ItemAwareElement)dataOutput2, "VARIABLE4");
        dataOutputAssociations.add(outputAssociation1);
        dataOutputAssociations.add(outputAssociation2);
        Mockito.when((Object)ioSpec.getDataInputs()).thenReturn(dataInputs);
        Mockito.when((Object)ioSpec.getDataOutputs()).thenReturn(dataOutputs);
        Mockito.when((Object)this.activity.getIoSpecification()).thenReturn((Object)ioSpec);
        Mockito.when((Object)this.activity.getDataInputAssociations()).thenReturn(dataInputAssociations);
        Mockito.when((Object)this.activity.getDataOutputAssociations()).thenReturn(dataOutputAssociations);
        AssignmentsInfo result = this.reader.getAssignmentsInfo();
        String expectedResult = "|INPUT_NAME_1:Integer,INPUT_NAME_2:String||OUTPUT_NAME_1:Boolean,OUTPUT_NAME_2:Float|[din]VARIABLE1->INPUT_NAME_1,[din]VARIABLE2->INPUT_NAME_2,[dout]OUTPUT_NAME_1->VARIABLE3,[dout]OUTPUT_NAME_2->VARIABLE4";
        Assert.assertEquals((Object)expectedResult, (Object)result.getValue());
    }

    @Test
    public void testGetAssignmentsInfoWithNoAssignments() {
        ArrayList dataInputs = new ArrayList();
        ArrayList dataInputAssociations = new ArrayList();
        ArrayList dataOutputs = new ArrayList();
        ArrayList dataOutputAssociations = new ArrayList();
        InputOutputSpecification ioSpec = (InputOutputSpecification)Mockito.mock(InputOutputSpecification.class);
        Mockito.when((Object)ioSpec.getDataInputs()).thenReturn(dataInputs);
        Mockito.when((Object)ioSpec.getDataOutputs()).thenReturn(dataOutputs);
        Mockito.when((Object)this.activity.getIoSpecification()).thenReturn((Object)ioSpec);
        Mockito.when((Object)this.activity.getDataInputAssociations()).thenReturn(dataInputAssociations);
        Mockito.when((Object)this.activity.getDataOutputAssociations()).thenReturn(dataOutputAssociations);
        AssignmentsInfo result = this.reader.getAssignmentsInfo();
        Assert.assertEquals((Object)"||||", (Object)result.getValue());
    }

    private static void assertScript(String expectedLanguage, String expectedScript, ScriptTypeListValue value) {
        Assert.assertEquals((long)1L, (long)value.getValues().size());
        Assert.assertEquals((Object)expectedLanguage, (Object)((ScriptTypeValue)value.getValues().get(0)).getLanguage());
        Assert.assertEquals((Object)expectedScript, (Object)((ScriptTypeValue)value.getValues().get(0)).getScript());
    }

    public static List<ExtensionAttributeValue> mockExtensions(EStructuralFeature feature, Object value) {
        FeatureMap featureMap = (FeatureMap)Mockito.mock(FeatureMap.class);
        Mockito.when((Object)featureMap.get(feature, true)).thenReturn(value);
        ExtensionAttributeValue attributeValue = (ExtensionAttributeValue)Mockito.mock(ExtensionAttributeValue.class);
        Mockito.when((Object)attributeValue.getValue()).thenReturn((Object)featureMap);
        return Collections.singletonList(attributeValue);
    }

    public static DataInput mockDataInput(String id, String name) {
        return ActivityPropertyReaderTest.mockDataInput(id, name, new FeatureMap.Entry[0]);
    }

    public static DataInput mockDataInput(String id, String name, FeatureMap.Entry ... entries) {
        ItemDefinition itemDefinition = (ItemDefinition)Mockito.mock(ItemDefinition.class);
        Mockito.when((Object)itemDefinition.getStructureRef()).thenReturn((Object)"java.lang.Object");
        DataInput dataInput = (DataInput)Mockito.mock(DataInput.class);
        Mockito.when((Object)dataInput.getItemSubjectRef()).thenReturn((Object)itemDefinition);
        Mockito.when((Object)dataInput.getId()).thenReturn((Object)id);
        Mockito.when((Object)dataInput.getName()).thenReturn((Object)name);
        ArrayList<FeatureMap.Entry> entriesList = new ArrayList<FeatureMap.Entry>();
        if (entries != null) {
            entriesList.addAll(Arrays.asList(entries));
        }
        FeatureMap featureMap = (FeatureMap)Mockito.mock(FeatureMap.class);
        Mockito.when((Object)featureMap.stream()).thenReturn(entriesList.stream());
        Mockito.when((Object)dataInput.getAnyAttribute()).thenReturn((Object)featureMap);
        return dataInput;
    }

    public static DataOutput mockDataOutput(String id, String name) {
        return ActivityPropertyReaderTest.mockDataOutput(id, name, new FeatureMap.Entry[0]);
    }

    public static DataOutput mockDataOutput(String id, String name, FeatureMap.Entry ... entries) {
        ItemDefinition itemDefinition = (ItemDefinition)Mockito.mock(ItemDefinition.class);
        Mockito.when((Object)itemDefinition.getStructureRef()).thenReturn((Object)"java.lang.Object");
        DataOutput dataOutput = (DataOutput)Mockito.mock(DataOutput.class);
        Mockito.when((Object)dataOutput.getItemSubjectRef()).thenReturn((Object)itemDefinition);
        Mockito.when((Object)dataOutput.getId()).thenReturn((Object)id);
        Mockito.when((Object)dataOutput.getName()).thenReturn((Object)name);
        ArrayList<FeatureMap.Entry> entriesList = new ArrayList<FeatureMap.Entry>();
        if (entries != null) {
            entriesList.addAll(Arrays.asList(entries));
        }
        FeatureMap featureMap = (FeatureMap)Mockito.mock(FeatureMap.class);
        Mockito.when((Object)featureMap.stream()).thenReturn(entriesList.stream());
        Mockito.when((Object)dataOutput.getAnyAttribute()).thenReturn((Object)featureMap);
        return dataOutput;
    }

    public static DataInputAssociation mockDataInputAssociation(String targetRef, String sourceRef) {
        return ActivityPropertyReaderTest.mockDataInputAssociation(ActivityPropertyReaderTest.mockItemAwareElement(targetRef), sourceRef);
    }

    public static DataInputAssociation mockDataInputAssociation(ItemAwareElement targetRefItem, String sourceRef) {
        DataInputAssociation inputAssociation = (DataInputAssociation)Mockito.mock(DataInputAssociation.class);
        Mockito.when((Object)inputAssociation.getTargetRef()).thenReturn((Object)targetRefItem);
        Property sourceRefItem = ActivityPropertyReaderTest.mockProperty(sourceRef);
        List<Property> sourceRefs = Collections.singletonList(sourceRefItem);
        Mockito.when((Object)inputAssociation.getSourceRef()).thenReturn(sourceRefs);
        return inputAssociation;
    }

    public static DataOutputAssociation mockDataOutputAssociation(String sourceRef, String targetRef) {
        return ActivityPropertyReaderTest.mockDataOutputAssociation(ActivityPropertyReaderTest.mockItemAwareElement(sourceRef), targetRef);
    }

    public static DataOutputAssociation mockDataOutputAssociation(ItemAwareElement sourceRefItem, String targetRef) {
        DataOutputAssociation outputAssociation = (DataOutputAssociation)Mockito.mock(DataOutputAssociation.class);
        List<ItemAwareElement> sourceRefs = Collections.singletonList(sourceRefItem);
        Mockito.when((Object)outputAssociation.getSourceRef()).thenReturn(sourceRefs);
        Property targetRefItem = ActivityPropertyReaderTest.mockProperty(targetRef);
        Mockito.when((Object)outputAssociation.getTargetRef()).thenReturn((Object)targetRefItem);
        return outputAssociation;
    }

    public static ItemAwareElement mockItemAwareElement(String id) {
        ItemAwareElement item = (ItemAwareElement)Mockito.mock(ItemAwareElement.class);
        Mockito.when((Object)item.getId()).thenReturn((Object)id);
        return item;
    }

    public static Property mockProperty(String id) {
        Property property = (Property)Mockito.mock(Property.class);
        Mockito.when((Object)property.getId()).thenReturn((Object)id);
        return property;
    }

    public FeatureMap.Entry mockEntry(String name, Object value) {
        FeatureMap.Entry entry = (FeatureMap.Entry)Mockito.mock(FeatureMap.Entry.class);
        EStructuralFeature feature = (EStructuralFeature)Mockito.mock(EStructuralFeature.class);
        Mockito.when((Object)feature.getName()).thenReturn((Object)name);
        Mockito.when((Object)entry.getEStructuralFeature()).thenReturn((Object)feature);
        Mockito.when((Object)entry.getValue()).thenReturn(value);
        return entry;
    }
}

