/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.bpmn.backend.converters.tostunner.properties;

import java.util.Collections;
import java.util.List;
import org.eclipse.bpmn2.Definitions;
import org.eclipse.bpmn2.Import;
import org.eclipse.bpmn2.Process;
import org.eclipse.bpmn2.di.BPMNDiagram;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.stunner.bpmn.backend.converters.fromstunner.Factories;
import org.kie.workbench.common.stunner.bpmn.backend.converters.fromstunner.properties.util.PropertyWriterUtils;
import org.kie.workbench.common.stunner.bpmn.backend.converters.tostunner.DefinitionResolver;
import org.kie.workbench.common.stunner.bpmn.backend.converters.tostunner.properties.DefinitionsPropertyReader;
import org.kie.workbench.common.stunner.bpmn.definition.property.diagram.imports.WSDLImport;
import org.mockito.runners.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class DefinitionsPropertyReaderTest {
    private Definitions definitions;
    private DefinitionResolver definitionResolver;
    private Process process;
    private DefinitionsPropertyReader tested;

    @Before
    public void setUp() {
        this.definitions = Factories.bpmn2.createDefinitions();
        this.process = Factories.bpmn2.createProcess();
        this.definitions.getRootElements().add(this.process);
        BPMNDiagram bpmnDiagram = Factories.di.createBPMNDiagram();
        bpmnDiagram.setPlane(Factories.di.createBPMNPlane());
        this.definitions.getDiagrams().add(bpmnDiagram);
        this.definitionResolver = new DefinitionResolver(this.definitions, Collections.emptyList());
        this.tested = new DefinitionsPropertyReader(this.definitionResolver.getDefinitions(), this.definitionResolver.getDiagram(), this.definitionResolver.getShape(this.process.getId()), this.definitionResolver.getResolutionFactor());
    }

    @Test
    public void getWSDLImports() {
        String LOCATION = "location";
        String NAMESPACE = "namespace";
        int QTY = 10;
        for (int i = 0; i < 10; ++i) {
            Import imp = PropertyWriterUtils.toImport((WSDLImport)new WSDLImport("location" + i, "namespace" + i));
            this.definitions.getImports().add(imp);
        }
        List wsdlImports = this.tested.getWSDLImports();
        Assert.assertEquals((long)10L, (long)wsdlImports.size());
        for (int i = 0; i < 10; ++i) {
            Assert.assertEquals((Object)("location" + i), (Object)((WSDLImport)wsdlImports.get(i)).getLocation());
            Assert.assertEquals((Object)("namespace" + i), (Object)((WSDLImport)wsdlImports.get(i)).getNamespace());
        }
    }
}

