/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.bpmn.backend.converters.tostunner.properties;

import org.eclipse.bpmn2.Activity;
import org.eclipse.bpmn2.CompensateEventDefinition;
import org.eclipse.bpmn2.Error;
import org.eclipse.bpmn2.ErrorEventDefinition;
import org.eclipse.bpmn2.Escalation;
import org.eclipse.bpmn2.EscalationEventDefinition;
import org.eclipse.bpmn2.Message;
import org.eclipse.bpmn2.MessageEventDefinition;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.stunner.bpmn.backend.converters.tostunner.properties.EventDefinitionReader;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class EventDefinitionReaderTest {
    private static final String SOME_VALUE = "SOME_VALUE";
    @Mock
    private ErrorEventDefinition errorEventDefinition;
    @Mock
    private MessageEventDefinition messageEventDefinition;
    @Mock
    private EscalationEventDefinition escalationEventDefinition;
    @Mock
    private CompensateEventDefinition compensateEventDefinition;

    @Test
    public void testErrorRefOfWithValue() {
        Error error = (Error)Mockito.mock(Error.class);
        Mockito.when((Object)error.getErrorCode()).thenReturn((Object)SOME_VALUE);
        this.testErrorRef(error, SOME_VALUE);
    }

    @Test
    public void testErrorRefOfWithNOValue() {
        this.testErrorRef(null, "");
    }

    private void testErrorRef(Error error, String expectedValue) {
        Mockito.when((Object)this.errorEventDefinition.getErrorRef()).thenReturn((Object)error);
        Assert.assertEquals((Object)expectedValue, (Object)EventDefinitionReader.errorRefOf((ErrorEventDefinition)this.errorEventDefinition));
    }

    @Test
    public void testMessageRefOfWithValue() {
        Message message = (Message)Mockito.mock(Message.class);
        Mockito.when((Object)message.getName()).thenReturn((Object)SOME_VALUE);
        this.testMessageRefOf(message, SOME_VALUE);
    }

    @Test
    public void testMessageRefOfWithNoValue() {
        this.testMessageRefOf(null, "");
    }

    private void testMessageRefOf(Message message, String expectedValue) {
        Mockito.when((Object)this.messageEventDefinition.getMessageRef()).thenReturn((Object)message);
        Assert.assertEquals((Object)expectedValue, (Object)EventDefinitionReader.messageRefOf((MessageEventDefinition)this.messageEventDefinition));
    }

    @Test
    public void testEscalationRefOfWithValue() {
        Escalation escalation = (Escalation)Mockito.mock(Escalation.class);
        Mockito.when((Object)escalation.getEscalationCode()).thenReturn((Object)SOME_VALUE);
        this.testEscalationRefOf(escalation, SOME_VALUE);
    }

    @Test
    public void testEscalationRefOfWithNoValue() {
        this.testEscalationRefOf(null, "");
    }

    private void testEscalationRefOf(Escalation escalation, String expectedValue) {
        Mockito.when((Object)this.escalationEventDefinition.getEscalationRef()).thenReturn((Object)escalation);
        Assert.assertEquals((Object)expectedValue, (Object)EventDefinitionReader.escalationRefOf((EscalationEventDefinition)this.escalationEventDefinition));
    }

    @Test
    public void testActivityRefOfWithValue() {
        Activity activity = (Activity)Mockito.mock(Activity.class);
        Mockito.when((Object)activity.getId()).thenReturn((Object)SOME_VALUE);
        this.testActivityRefOf(activity, SOME_VALUE);
    }

    @Test
    public void testActivityRefOfWithNoValue() {
        this.testActivityRefOf(null, null);
    }

    private void testActivityRefOf(Activity activity, String expectedValue) {
        Mockito.when((Object)this.compensateEventDefinition.getActivityRef()).thenReturn((Object)activity);
        Assert.assertEquals((Object)expectedValue, (Object)EventDefinitionReader.activityRefOf((CompensateEventDefinition)this.compensateEventDefinition));
    }
}

