/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.bpmn.backend.converters.tostunner.properties;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.bpmn2.Assignment;
import org.eclipse.bpmn2.DataObject;
import org.eclipse.bpmn2.DataOutput;
import org.eclipse.bpmn2.DataOutputAssociation;
import org.eclipse.bpmn2.FormalExpression;
import org.eclipse.bpmn2.ItemAwareElement;
import org.eclipse.bpmn2.Property;
import org.eclipse.bpmn2.impl.DataOutputAssociationImpl;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.stunner.bpmn.backend.converters.customproperties.AssociationDeclaration;
import org.kie.workbench.common.stunner.bpmn.backend.converters.tostunner.properties.OutputAssignmentReader;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class OutputAssignmentReaderTest {
    private static final String SOURCE_NAME = "SOURCE_NAME";
    private static final String TARGET_NAME = "TARGET_NAME";
    private static final String TARGET_ID = "TARGET_ID";

    @Test
    public void testFromAssociationWithPropertyName() {
        Property property = OutputAssignmentReaderTest.mockProperty(TARGET_ID, TARGET_NAME);
        DataOutputAssociation outputAssociation = OutputAssignmentReaderTest.mockDataOutputAssociation(SOURCE_NAME, (ItemAwareElement)property);
        OutputAssignmentReader outputReader = OutputAssignmentReader.fromAssociation((DataOutputAssociation)outputAssociation);
        Assert.assertNotNull((Object)outputReader);
        this.assertResult(SOURCE_NAME, TARGET_NAME, AssociationDeclaration.Type.SourceTarget, outputReader.getAssociationDeclaration());
    }

    @Test
    public void testFromAssociationWithPropertyId() {
        Property property = OutputAssignmentReaderTest.mockProperty(TARGET_ID, null);
        DataOutputAssociation outputAssociation = OutputAssignmentReaderTest.mockDataOutputAssociation(SOURCE_NAME, (ItemAwareElement)property);
        OutputAssignmentReader outputReader = OutputAssignmentReader.fromAssociation((DataOutputAssociation)outputAssociation);
        Assert.assertNotNull((Object)outputReader);
        this.assertResult(SOURCE_NAME, TARGET_ID, AssociationDeclaration.Type.SourceTarget, outputReader.getAssociationDeclaration());
    }

    @Test
    public void testFromAssociationWithExpression() {
        DataOutput output = (DataOutput)Mockito.spy(DataOutput.class);
        Mockito.when((Object)output.getName()).thenReturn((Object)TARGET_NAME);
        Assignment assignment = (Assignment)Mockito.spy(Assignment.class);
        FormalExpression to = (FormalExpression)Mockito.mock(FormalExpression.class);
        Mockito.when((Object)assignment.getTo()).thenReturn((Object)to);
        Mockito.when((Object)to.getBody()).thenReturn((Object)SOURCE_NAME);
        ArrayList<Assignment> assignments = new ArrayList<Assignment>();
        assignments.add(assignment);
        DataOutputAssociationImpl out = (DataOutputAssociationImpl)Mockito.spy(DataOutputAssociationImpl.class);
        Mockito.when((Object)out.getAssignment()).thenReturn(assignments);
        OutputAssignmentReader outputReader = OutputAssignmentReader.fromAssociation((DataOutputAssociation)out);
        Assert.assertNull((Object)outputReader);
        ArrayList<DataOutput> outputs = new ArrayList<DataOutput>();
        outputs.add(output);
        Mockito.when((Object)out.getSourceRef()).thenReturn(outputs);
        outputReader = OutputAssignmentReader.fromAssociation((DataOutputAssociation)out);
        this.assertResult(TARGET_NAME, SOURCE_NAME, AssociationDeclaration.Type.FromTo, outputReader.getAssociationDeclaration());
        Mockito.when((Object)to.getBody()).thenReturn((Object)"null");
        outputReader = OutputAssignmentReader.fromAssociation((DataOutputAssociation)out);
        this.assertResult(TARGET_NAME, "", AssociationDeclaration.Type.FromTo, outputReader.getAssociationDeclaration());
    }

    @Test
    public void testFromAssociationWithDataObjectItem() {
        ItemAwareElement item = (ItemAwareElement)Mockito.mock(DataObject.class);
        DataOutputAssociation outputAssociation = OutputAssignmentReaderTest.mockDataOutputAssociation(SOURCE_NAME, item);
        OutputAssignmentReader outputReader = OutputAssignmentReader.fromAssociation((DataOutputAssociation)outputAssociation);
        Assert.assertNotNull((Object)outputReader);
        Assert.assertNotNull((String)SOURCE_NAME, (Object)outputReader.getAssociationDeclaration());
    }

    private void assertResult(String sourceName, String targetId, AssociationDeclaration.Type type, AssociationDeclaration associationDeclaration) {
        Assert.assertNotNull((Object)associationDeclaration);
        Assert.assertEquals((Object)sourceName, (Object)associationDeclaration.getSource());
        Assert.assertEquals((Object)targetId, (Object)associationDeclaration.getTarget());
        Assert.assertEquals((Object)type, (Object)associationDeclaration.getType());
        Assert.assertEquals((Object)AssociationDeclaration.Direction.Output, (Object)associationDeclaration.getDirection());
    }

    private static Property mockProperty(String id, String name) {
        Property property = (Property)Mockito.mock(Property.class);
        Mockito.when((Object)property.getId()).thenReturn((Object)id);
        Mockito.when((Object)property.getName()).thenReturn((Object)name);
        return property;
    }

    private static DataOutputAssociation mockDataOutputAssociation(String dataOutputName, ItemAwareElement targetRef) {
        DataOutputAssociation outputAssociation = (DataOutputAssociation)Mockito.mock(DataOutputAssociation.class);
        DataOutput dataOutput = (DataOutput)Mockito.mock(DataOutput.class);
        Mockito.when((Object)dataOutput.getName()).thenReturn((Object)dataOutputName);
        List<DataOutput> sourceRefs = Collections.singletonList(dataOutput);
        Mockito.when((Object)outputAssociation.getSourceRef()).thenReturn(sourceRefs);
        Mockito.when((Object)outputAssociation.getTargetRef()).thenReturn((Object)targetRef);
        return outputAssociation;
    }
}

