/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.bpmn.backend.service.diagram.marshalling.nodes;

import org.junit.Test;
import org.kie.workbench.common.stunner.bpmn.backend.service.diagram.marshalling.nodes.GatewayNodeTest;
import org.kie.workbench.common.stunner.bpmn.definition.ExclusiveGateway;
import org.kie.workbench.common.stunner.core.definition.service.DiagramMarshaller;
import org.kie.workbench.common.stunner.core.diagram.Diagram;
import org.kie.workbench.common.stunner.core.diagram.Metadata;
import org.kie.workbench.common.stunner.core.graph.Graph;

public class ExclusiveGatewayTest
extends GatewayNodeTest<ExclusiveGateway> {
    private static final String BPMN_EXCLUSIVE_GATEWAY_FILE_PATH = "org/kie/workbench/common/stunner/bpmn/backend/service/diagram/exclusiveGateways.bpmn";
    private static final String FILLED_TOP_LEVEL_GATEWAY_ID = "5C6F1A12-3B5D-4558-8F24-3DDE41F24A0A";
    private static final String EMPTY_TOP_LEVEL_GATEWAY_ID = "162CA3E2-47D1-40D9-B4AF-D6FB26F02A38";
    private static final String FILLED_SUBPROCESS_LEVEL_GATEWAY_ID = "66BF84BC-D7DB-485B-8AF7-4B6B3D219531";
    private static final String EMPTY_SUBPROCESS_LEVEL_GATEWAY_ID = "3AA557EF-C3F8-4D73-98BB-7F96D3B97DDF";
    private static final String DEFAULT_ROUTE_TOP_LEVEL_ID = "07474121-F19B-4620-BB97-C7688E63938B";
    private static final String DEFAULT_ROUTE_SUBPROCESS_LEVEL_ID = "A79B4FF1-3C2E-405C-83E0-32037B0D9D6D";
    private static final String DOCUMENTATION = "Some documentation as well ~`!@#$%^&*()_+=-{}|\\][:\";'?><,./";
    private static final String NAME = "Some name ~`!@#$%^&*()_+=-{}|\\][:\";'?><,./";
    private static final String EMPTY = "";

    @Test
    public void testUnmarshallTopLevelGatewayFilledProperties() throws Exception {
        Diagram<Graph, Metadata> diagram = this.unmarshall((DiagramMarshaller<Graph, Metadata, Diagram<Graph, Metadata>>)this.marshaller, BPMN_EXCLUSIVE_GATEWAY_FILE_PATH);
        this.assertDiagram(diagram, 10);
        ExclusiveGateway filledTopLevelGateway = this.getGatewayNodeById(diagram, FILLED_TOP_LEVEL_GATEWAY_ID, this.getGatewayNodeType());
        this.assertGeneralSet(filledTopLevelGateway.getGeneral(), NAME, DOCUMENTATION);
        this.assertGatewayExecutionSet(filledTopLevelGateway.getExecutionSet(), DEFAULT_ROUTE_TOP_LEVEL_ID);
    }

    @Test
    public void testUnmarshallTopLevelEmptyGatewayProperties() throws Exception {
        Diagram<Graph, Metadata> diagram = this.unmarshall((DiagramMarshaller<Graph, Metadata, Diagram<Graph, Metadata>>)this.marshaller, BPMN_EXCLUSIVE_GATEWAY_FILE_PATH);
        this.assertDiagram(diagram, 10);
        ExclusiveGateway filledTopLevelGateway = this.getGatewayNodeById(diagram, EMPTY_TOP_LEVEL_GATEWAY_ID, this.getGatewayNodeType());
        this.assertGeneralSet(filledTopLevelGateway.getGeneral(), EMPTY, EMPTY);
        this.assertGatewayExecutionSet(filledTopLevelGateway.getExecutionSet(), null);
    }

    @Test
    public void testUnmarshallSubprocessLevelGatewayFilledProperties() throws Exception {
        Diagram<Graph, Metadata> diagram = this.unmarshall((DiagramMarshaller<Graph, Metadata, Diagram<Graph, Metadata>>)this.marshaller, BPMN_EXCLUSIVE_GATEWAY_FILE_PATH);
        this.assertDiagram(diagram, 10);
        ExclusiveGateway filledTopLevelGateway = this.getGatewayNodeById(diagram, FILLED_SUBPROCESS_LEVEL_GATEWAY_ID, this.getGatewayNodeType());
        this.assertGeneralSet(filledTopLevelGateway.getGeneral(), NAME, DOCUMENTATION);
        this.assertGatewayExecutionSet(filledTopLevelGateway.getExecutionSet(), DEFAULT_ROUTE_SUBPROCESS_LEVEL_ID);
    }

    @Test
    public void testUnmarshallSubprocessLevelGatewayEmptyProperties() throws Exception {
        Diagram<Graph, Metadata> diagram = this.unmarshall((DiagramMarshaller<Graph, Metadata, Diagram<Graph, Metadata>>)this.marshaller, BPMN_EXCLUSIVE_GATEWAY_FILE_PATH);
        this.assertDiagram(diagram, 10);
        ExclusiveGateway filledTopLevelGateway = this.getGatewayNodeById(diagram, EMPTY_SUBPROCESS_LEVEL_GATEWAY_ID, this.getGatewayNodeType());
        this.assertGeneralSet(filledTopLevelGateway.getGeneral(), EMPTY, EMPTY);
        this.assertGatewayExecutionSet(filledTopLevelGateway.getExecutionSet(), null);
    }

    @Override
    Class<ExclusiveGateway> getGatewayNodeType() {
        return ExclusiveGateway.class;
    }

    @Override
    String getGatewayNodeFilePath() {
        return BPMN_EXCLUSIVE_GATEWAY_FILE_PATH;
    }

    @Override
    String getFilledTopLevelGatewayId() {
        return FILLED_TOP_LEVEL_GATEWAY_ID;
    }

    @Override
    String getEmptyTopLevelGatewayId() {
        return EMPTY_TOP_LEVEL_GATEWAY_ID;
    }

    @Override
    String getFilledSubprocessLevelGatewayId() {
        return FILLED_SUBPROCESS_LEVEL_GATEWAY_ID;
    }

    @Override
    String getEmptySubprocessLevelGatewayId() {
        return EMPTY_SUBPROCESS_LEVEL_GATEWAY_ID;
    }
}

