/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dd.dc.util;

import java.util.Map;
import org.eclipse.dd.dc.Bounds;
import org.eclipse.dd.dc.DcPackage;
import org.eclipse.dd.dc.DocumentRoot;
import org.eclipse.dd.dc.Font;
import org.eclipse.dd.dc.Point;
import org.eclipse.emf.common.util.DiagnosticChain;
import org.eclipse.emf.common.util.ResourceLocator;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.util.EObjectValidator;

public class DcValidator
extends EObjectValidator {
    public static final DcValidator INSTANCE = new DcValidator();
    public static final String DIAGNOSTIC_SOURCE = "org.eclipse.dd.dc";
    public static final int FONT__NON_NEGATIVE_SIZE = 1;
    private static final int GENERATED_DIAGNOSTIC_CODE_COUNT = 1;
    protected static final int DIAGNOSTIC_CODE_COUNT = 1;

    protected EPackage getEPackage() {
        return DcPackage.eINSTANCE;
    }

    protected boolean validate(int classifierID, Object value, DiagnosticChain diagnostics, Map<Object, Object> context) {
        switch (classifierID) {
            case 0: {
                return this.validateDocumentRoot((DocumentRoot)value, diagnostics, context);
            }
            case 1: {
                return this.validateBounds((Bounds)value, diagnostics, context);
            }
            case 2: {
                return this.validateFont((Font)value, diagnostics, context);
            }
            case 3: {
                return this.validatePoint((Point)value, diagnostics, context);
            }
        }
        return true;
    }

    public boolean validateDocumentRoot(DocumentRoot documentRoot, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint(documentRoot, diagnostics, context);
    }

    public boolean validateBounds(Bounds bounds, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint(bounds, diagnostics, context);
    }

    public boolean validateFont(Font font, DiagnosticChain diagnostics, Map<Object, Object> context) {
        boolean result = this.validate_EveryMultiplicityConforms(font, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms(font, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained(font, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves(font, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID(font, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique(font, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique(font, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateFont_non_negative_size(font, diagnostics, context);
        }
        return result;
    }

    public boolean validateFont_non_negative_size(Font font, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return font.non_negative_size(diagnostics, context);
    }

    public boolean validatePoint(Point point, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint(point, diagnostics, context);
    }

    public ResourceLocator getResourceLocator() {
        return super.getResourceLocator();
    }
}

