/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.bpmn.definition.property.variables;

import java.util.AbstractMap;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class ProcessVariableSerializer {
    public static Map<String, VariableInfo> deserialize(String serializedVariables) {
        return Stream.of(serializedVariables.split(",")).filter(s -> !s.isEmpty()).map(ProcessVariableSerializer::deserializeVariable).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    private static Map.Entry<String, VariableInfo> deserializeVariable(String encoded) {
        String type;
        String[] split = encoded.split(":");
        String identifier = split[0];
        String string = type = split.length == 2 || split.length == 3 ? split[1] : "";
        if (identifier.isEmpty()) {
            throw new IllegalArgumentException("Variable identifier cannot be empty. Given: '" + encoded + "'");
        }
        String tags = split[2];
        return new AbstractMap.SimpleEntry<String, VariableInfo>(identifier, new VariableInfo(type, tags));
    }

    public static class VariableInfo {
        public final String type;
        public final String tags;

        VariableInfo(String type, String tags) {
            this.type = type;
            this.tags = tags;
        }

        public String getType() {
            return this.type;
        }

        public String getTags() {
            return this.tags;
        }
    }
}

