/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.transfer;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.dashbuilder.dataset.DataSetLookup;
import org.dashbuilder.dataset.def.DataSetDef;
import org.dashbuilder.displayer.DisplayerSettings;
import org.dashbuilder.displayer.json.DisplayerSettingsJSONMarshaller;
import org.dashbuilder.navigation.service.PerspectivePluginServices;
import org.dashbuilder.transfer.DataTransferExportModel;
import org.dashbuilder.transfer.ExportModelValidationService;
import org.jboss.errai.bus.server.annotations.Service;

@Service
@ApplicationScoped
public class ExportModelValidationServiceImpl
implements ExportModelValidationService {
    PerspectivePluginServices perspectivePluginServices;
    DisplayerSettingsJSONMarshaller marshaller;

    public ExportModelValidationServiceImpl() {
    }

    @Inject
    public ExportModelValidationServiceImpl(PerspectivePluginServices perspectivePluginServices) {
        this(perspectivePluginServices, DisplayerSettingsJSONMarshaller.get());
    }

    ExportModelValidationServiceImpl(PerspectivePluginServices perspectivePluginServices, DisplayerSettingsJSONMarshaller marshaller) {
        this.perspectivePluginServices = perspectivePluginServices;
        this.marshaller = marshaller;
    }

    public Map<String, List<String>> checkMissingDatasets(DataTransferExportModel exportModel) {
        if (exportModel == null || exportModel.getPages().isEmpty()) {
            return Collections.emptyMap();
        }
        Map<String, List<String>> deps = exportModel.getPages().stream().collect(Collectors.toMap(p -> p, p -> this.datasetsUsedInPage((String)p, exportModel)));
        deps.entrySet().removeIf(e -> ((List)e.getValue()).isEmpty());
        return deps;
    }

    private List<String> datasetsUsedInPage(String p, DataTransferExportModel exportModel) {
        List exportedDefs = exportModel.getDatasetDefinitions();
        return this.allDataSetsFromPage(p).filter(uuid -> this.isDataSetMissing((String)uuid, exportedDefs)).distinct().collect(Collectors.toList());
    }

    private boolean isDataSetMissing(String uuid, List<DataSetDef> exportedDefs) {
        return exportedDefs.isEmpty() || exportedDefs.stream().noneMatch(ds -> ds.getUUID().equals(uuid));
    }

    private Stream<String> allDataSetsFromPage(String p) {
        return this.perspectivePluginServices.getLayoutTemplate(p).getRows().stream().flatMap(r -> r.getLayoutColumns().stream()).flatMap(cl -> cl.getLayoutComponents().stream()).map(lc -> (String)lc.getProperties().get("json")).filter(Objects::nonNull).map(arg_0 -> ((DisplayerSettingsJSONMarshaller)this.marshaller).fromJsonString(arg_0)).map(DisplayerSettings::getDataSetLookup).filter(Objects::nonNull).map(DataSetLookup::getDataSetUUID).filter(Objects::nonNull);
    }
}

